/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.core.DDSpan;
import java.util.List;

public class Monitor {
    private final StatsDClient statsd;

    public Monitor(StatsDClient statsd) {
        this.statsd = statsd;
    }

    public void onStart(DDAgentWriter agentWriter) {
        this.statsd.recordGaugeValue("queue.max_length", agentWriter.getDisruptorCapacity(), new String[0]);
    }

    public void onShutdown(DDAgentWriter agentWriter, boolean flushSuccess) {
    }

    public void onPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
        this.statsd.incrementCounter("queue.accepted", new String[0]);
        this.statsd.count("queue.accepted_lengths", (long)trace.size(), new String[0]);
    }

    public void onFailedPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
        this.statsd.incrementCounter("queue.dropped", new String[0]);
    }

    public void onScheduleFlush(DDAgentWriter agentWriter, boolean previousIncomplete) {
    }

    public void onFlush(DDAgentWriter agentWriter, boolean early) {
    }

    public void onSerialize(int serializedSizeInBytes) {
        this.statsd.count("queue.accepted_size", (long)serializedSizeInBytes, new String[0]);
    }

    public void onFailedSerialize(DDAgentWriter agentWriter, List<DDSpan> trace, Throwable optionalCause) {
    }

    public void onSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(agentWriter, representativeCount, sizeInBytes, response);
    }

    public void onFailedSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(agentWriter, representativeCount, sizeInBytes, response);
    }

    private void onSendAttempt(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.statsd.incrementCounter("api.requests", new String[0]);
        this.statsd.recordGaugeValue("queue.length", (long)representativeCount, new String[0]);
        this.statsd.recordGaugeValue("queue.size", (long)sizeInBytes, new String[0]);
        if (response.exception() != null) {
            this.statsd.incrementCounter("api.errors", new String[0]);
        }
        if (response.status() != null) {
            this.statsd.incrementCounter("api.responses", new String[]{"status: " + response.status()});
        }
    }
}

