/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.StringTables;
import datadog.trace.core.serialization.msgpack.EncodingCachingStrategies;
import datadog.trace.core.serialization.msgpack.Mapper;
import datadog.trace.core.serialization.msgpack.Writable;
import java.util.List;
import java.util.Map;

public final class TraceMapper
implements Mapper<List<DDSpan>> {
    private static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private final byte[] numberByteArray = new byte[20];

    @Override
    public void map(List<DDSpan> trace, final Writable writable) {
        writable.startArray(trace.size());
        for (DDSpan span : trace) {
            writable.startMap(12);
            writable.writeUTF8(StringTables.SERVICE);
            writable.writeString(span.getServiceName(), EncodingCachingStrategies.CONSTANT_TAGS);
            writable.writeUTF8(StringTables.NAME);
            writable.writeString(span.getOperationName(), EncodingCachingStrategies.CONSTANT_TAGS);
            writable.writeUTF8(StringTables.RESOURCE);
            writable.writeObject(span.getResourceName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(StringTables.SPAN_ID);
            writable.writeLong(span.getSpanId().toLong());
            writable.writeUTF8(StringTables.PARENT_ID);
            writable.writeLong(span.getParentId().toLong());
            writable.writeUTF8(StringTables.START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(StringTables.DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(StringTables.TYPE);
            writable.writeString(span.getType(), EncodingCachingStrategies.CONSTANT_TAGS);
            writable.writeUTF8(StringTables.ERROR);
            writable.writeInt(span.getError());
            writable.writeUTF8(StringTables.METRICS);
            writable.writeMap(span.getMetrics(), EncodingCachingStrategies.CONSTANT_KEYS);
            writable.writeUTF8(StringTables.META);
            span.context().processTagsAndBaggage(new DDSpanContext.TagsAndBaggageConsumer(){

                @Override
                public void accept(Map<String, Object> tags, Map<String, String> baggage) {
                    int size = tags.size();
                    boolean overlap = false;
                    if (baggage.size() > 0) {
                        for (String string : baggage.keySet()) {
                            if (!tags.containsKey(string)) {
                                ++size;
                                continue;
                            }
                            overlap = true;
                        }
                    }
                    writable.startMap(size);
                    for (Map.Entry entry : baggage.entrySet()) {
                        if (overlap && tags.containsKey(entry.getKey())) continue;
                        writable.writeString((CharSequence)entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                        writable.writeObject(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
                    }
                    for (Map.Entry entry : tags.entrySet()) {
                        writable.writeString((CharSequence)entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                        if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer) {
                            TraceMapper.this.writeLongAsString(((Number)entry.getValue()).longValue(), writable);
                            continue;
                        }
                        if (entry.getValue() instanceof UTF8BytesString) {
                            writable.writeObject(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
                            continue;
                        }
                        writable.writeString(String.valueOf(entry.getValue()), EncodingCachingStrategies.NO_CACHING);
                    }
                }
            });
        }
    }

    private void writeLongAsString(long value, Writable destination) {
        int iq;
        int r;
        boolean negative;
        int pos = 20;
        long l = value;
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        while (l <= Integer.MIN_VALUE) {
            long lq = l / 100L;
            r = (int)(lq * 100L - l);
            l = lq;
            this.numberByteArray[--pos] = DIGIT_ONES[r];
            this.numberByteArray[--pos] = DIGIT_TENS[r];
        }
        int i = (int)l;
        while (i <= -100) {
            iq = i / 100;
            r = iq * 100 - i;
            i = iq;
            this.numberByteArray[--pos] = DIGIT_ONES[r];
            this.numberByteArray[--pos] = DIGIT_TENS[r];
        }
        iq = i / 10;
        r = iq * 10 - i;
        this.numberByteArray[--pos] = (byte)(48 + r);
        if (iq < 0) {
            this.numberByteArray[--pos] = (byte)(48 - iq);
        }
        if (negative) {
            this.numberByteArray[--pos] = 45;
        }
        int len = 20 - pos;
        destination.writeUTF8(this.numberByteArray, pos, len);
    }
}

