/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ContextInterpreter;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContextExtractor;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaystackHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HaystackHttpCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "Baggage-";
    private static final String TRACE_ID_KEY = "Trace-ID";
    private static final String SPAN_ID_KEY = "Span-ID";
    private static final String PARENT_ID_KEY = "Parent_ID";

    private HaystackHttpCodec() {
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping) {
        return new TagContextExtractor(tagMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping) {
                return new HaystackContextInterpreter(mapping);
            }
        });
    }

    private static class HaystackContextInterpreter
    extends ContextInterpreter {
        private static final String BAGGAGE_PREFIX_LC = "baggage-";
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int TAGS = 2;
        private static final int BAGGAGE = 3;
        private static final int IGNORE = -1;

        private HaystackContextInterpreter(Map<String, String> taggedHeaders) {
            super(taggedHeaders);
        }

        @Override
        public boolean accept(String key, String value) {
            char first = Character.toLowerCase(key.charAt(0));
            String lowerCaseKey = null;
            int classification = -1;
            switch (first) {
                case 't': {
                    if (!HaystackHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 0;
                    break;
                }
                case 's': {
                    if (!HaystackHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 1;
                    break;
                }
                case 'b': {
                    lowerCaseKey = this.toLowerCase(key);
                    if (!lowerCaseKey.startsWith(BAGGAGE_PREFIX_LC)) break;
                    classification = 3;
                }
            }
            if (!this.taggedHeaders.isEmpty() && classification == -1 && this.taggedHeaders.containsKey(lowerCaseKey = this.toLowerCase(key))) {
                classification = 2;
            }
            if (-1 != classification) {
                try {
                    String firstValue = HttpCodec.firstHeaderValue(value);
                    if (null != firstValue) {
                        switch (classification) {
                            case 0: {
                                this.traceId = DDId.from((String)firstValue);
                                break;
                            }
                            case 1: {
                                this.spanId = DDId.from((String)firstValue);
                                break;
                            }
                            case 2: {
                                String mappedKey = (String)this.taggedHeaders.get(lowerCaseKey);
                                if (null == mappedKey) break;
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(mappedKey, HttpCodec.decode(value));
                                break;
                            }
                            case 3: {
                                if (this.baggage.isEmpty()) {
                                    this.baggage = new TreeMap();
                                }
                                this.baggage.put(lowerCaseKey.substring(BAGGAGE_PREFIX_LC.length()), HttpCodec.decode(value));
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.error("Exception when extracting context", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        @Override
        protected int defaultSamplingPriority() {
            return 1;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            setter.set(carrier, HaystackHttpCodec.TRACE_ID_KEY, context.getTraceId().toString());
            setter.set(carrier, HaystackHttpCodec.SPAN_ID_KEY, context.getSpanId().toString());
            setter.set(carrier, HaystackHttpCodec.PARENT_ID_KEY, context.getParentId().toString());
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                setter.set(carrier, HaystackHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            log.debug("{} - Haystack parent context injected", (Object)context.getTraceId());
        }
    }
}

