/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDSpanContext;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.decorators.AbstractDecorator;
import datadog.opentracing.decorators.DDDecoratorsFactory;
import datadog.opentracing.propagation.Codec;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.HTTPCodec;
import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.opentracing.scopemanager.ScopeContext;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.common.DDTraceConfig;
import datadog.trace.common.Service;
import datadog.trace.common.sampling.AllSampler;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.DDApi;
import datadog.trace.common.writer.Writer;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracer
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger(DDTracer.class);
    public static final String UNASSIGNED_DEFAULT_SERVICE_NAME = "unnamed-java-app";
    final String serviceName;
    final Writer writer;
    final Sampler sampler;
    final ContextualScopeManager scopeManager = new ContextualScopeManager();
    private final Map<String, Object> spanTags;
    private final Map<String, List<AbstractDecorator>> spanContextDecorators = new ConcurrentHashMap<String, List<AbstractDecorator>>();
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final CodecRegistry registry;
    private final Map<String, Service> services = new HashMap<String, Service>();

    public DDTracer() {
        this(new DDTraceConfig());
    }

    public DDTracer(String serviceName) {
        this(new DDTraceConfig(serviceName));
    }

    public DDTracer(Properties config) {
        this(config.getProperty("service.name"), Writer.Builder.forConfig(config), Sampler.Builder.forConfig(config), DDTraceConfig.parseMap(config.getProperty("trace.span.tags")));
        log.debug("Using config: {}", (Object)config);
    }

    public DDTracer(String serviceName, Writer writer, Sampler sampler) {
        this(serviceName, writer, sampler, Collections.emptyMap());
    }

    public DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, Object> spanTags) {
        this.serviceName = serviceName;
        this.writer = writer;
        this.writer.start();
        this.sampler = sampler;
        this.spanTags = spanTags;
        this.registry = new CodecRegistry();
        this.registry.register(Format.Builtin.HTTP_HEADERS, new HTTPCodec());
        this.registry.register(Format.Builtin.TEXT_MAP, new HTTPCodec());
        if (this.writer instanceof DDAgentWriter && sampler instanceof DDApi.ResponseListener) {
            DDApi api = ((DDAgentWriter)this.writer).getApi();
            api.addResponseListener((DDApi.ResponseListener)((Object)this.sampler));
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        List<AbstractDecorator> decorators = DDDecoratorsFactory.createBuiltinDecorators();
        for (AbstractDecorator decorator : decorators) {
            log.debug("Loading decorator: {}", (Object)decorator.getClass().getSimpleName());
            this.addDecorator(decorator);
        }
        log.info("New instance: {}", (Object)this);
    }

    public DDTracer(Writer writer) {
        this(UNASSIGNED_DEFAULT_SERVICE_NAME, writer, new AllSampler(), DDTraceConfig.parseMap(new DDTraceConfig().getProperty("trace.span.tags")));
    }

    public List<AbstractDecorator> getSpanContextDecorators(String tag) {
        return this.spanContextDecorators.get(tag);
    }

    public void addDecorator(AbstractDecorator decorator) {
        List<AbstractDecorator> list = this.spanContextDecorators.get(decorator.getMatchingTag());
        if (list == null) {
            list = new ArrayList<AbstractDecorator>();
        }
        list.add(decorator);
        this.spanContextDecorators.put(decorator.getMatchingTag(), list);
    }

    public boolean addInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public void addScopeContext(ScopeContext context) {
        this.scopeManager.addScopeContext(context);
    }

    public void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    public ContextualScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        Scope active = this.scopeManager.active();
        return active == null ? null : active.span();
    }

    public DDSpanBuilder buildSpan(String operationName) {
        return new DDSpanBuilder(operationName, this.scopeManager);
    }

    public <T> void inject(SpanContext spanContext, Format<T> format, T carrier) {
        Codec<T> codec = this.registry.get(format);
        if (codec == null) {
            log.warn("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        } else {
            codec.inject((DDSpanContext)spanContext, carrier);
        }
    }

    public <T> SpanContext extract(Format<T> format, T carrier) {
        Codec<T> codec = this.registry.get(format);
        if (codec != null) {
            return codec.extract(carrier);
        }
        log.warn("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        return null;
    }

    void write(PendingTrace trace) {
        ArrayList writtenTrace;
        if (trace.isEmpty()) {
            return;
        }
        if (this.interceptors.isEmpty()) {
            writtenTrace = Lists.newArrayList((Iterable)trace);
        } else {
            Collection interceptedTrace = Lists.newArrayList((Iterable)trace);
            for (TraceInterceptor interceptor : this.interceptors) {
                interceptedTrace = interceptor.onTraceComplete(interceptedTrace);
            }
            writtenTrace = Lists.newArrayListWithExpectedSize((int)interceptedTrace.size());
            for (MutableSpan span : interceptedTrace) {
                if (!(span instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)span);
            }
        }
        if (!writtenTrace.isEmpty() && this.sampler.sample((DDSpan)writtenTrace.get(0))) {
            this.writer.write(writtenTrace);
        }
    }

    public void close() {
        this.writer.close();
    }

    public String toString() {
        return "DDTracer-" + Integer.toHexString(this.hashCode()) + "{ service-name=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", tags=" + this.spanTags + '}';
    }

    public void addServiceInfo(Service service) {
        this.services.put(service.getName(), service);
        try {
            this.writer.writeServices(this.services);
        }
        catch (Throwable ex) {
            log.warn("Failed to report additional service information, reason: {}", (Object)ex.getMessage());
        }
    }

    @JsonIgnore
    public Map<String, Service> getServiceInfo() {
        return this.services;
    }

    public class DDSpanBuilder
    implements Tracer.SpanBuilder {
        private final ScopeManager scopeManager;
        private final String operationName;
        private Map<String, Object> tags;
        private long timestamp;
        private SpanContext parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private String spanType;
        private boolean ignoreScope;

        public DDSpanBuilder(String operationName, ScopeManager scopeManager) {
            this.tags = DDTracer.this.spanTags.isEmpty() ? Collections.emptyMap() : Maps.newHashMap((Map)DDTracer.this.spanTags);
            this.ignoreScope = false;
            this.operationName = operationName;
            this.scopeManager = scopeManager;
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan startSpan() {
            DDSpan span = new DDSpan(this.timestamp, this.buildSpanContext());
            if (DDTracer.this.sampler instanceof RateByServiceSampler) {
                ((RateByServiceSampler)DDTracer.this.sampler).initializeSamplingPriority(span);
            }
            return span;
        }

        public Scope startActive(boolean finishSpanOnClose) {
            DDSpan span = this.startSpan();
            Scope scope = this.scopeManager.activate((Span)span, finishSpanOnClose);
            log.debug("Starting a new active span: {}", (Object)span);
            return scope;
        }

        @Deprecated
        public DDSpan startManual() {
            return this.start();
        }

        public DDSpan start() {
            DDSpan span = this.startSpan();
            log.debug("Starting a new span: {}", (Object)span);
            return span;
        }

        public DDSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        public DDSpanBuilder withTag(String tag, String string) {
            if (tag.equals("service.name")) {
                return this.withServiceName(string);
            }
            if (tag.equals("resource.name")) {
                return this.withResourceName(string);
            }
            if (tag.equals("span.type")) {
                return this.withSpanType(string);
            }
            return this.withTag(tag, (Object)string);
        }

        public DDSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        public DDSpanBuilder withStartTimestamp(long timestampMillis) {
            this.timestamp = timestampMillis;
            return this;
        }

        public DDSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public DDSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public DDSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        public DDSpanBuilder withSpanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            if (this.parent == null) {
                return Collections.emptyList();
            }
            return this.parent.baggageItems();
        }

        public DDSpanBuilder asChildOf(Span span) {
            return this.asChildOf(span == null ? null : span.context());
        }

        public DDSpanBuilder asChildOf(SpanContext spanContext) {
            this.parent = spanContext;
            return this;
        }

        public DDSpanBuilder addReference(String referenceType, SpanContext spanContext) {
            log.debug("`addReference` method is not implemented. Doing nothing");
            return this;
        }

        private DDSpanBuilder withTag(String tag, Object value) {
            if (this.tags.isEmpty()) {
                this.tags = Maps.newHashMap();
            }
            this.tags.put(tag, value);
            return this;
        }

        private long generateNewId() {
            return ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE);
        }

        private DDSpanContext buildSpanContext() {
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            long parentSpanId;
            long traceId;
            Object ddsc;
            Scope scope;
            long spanId = this.generateNewId();
            SpanContext parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (scope = this.scopeManager.active()) != null) {
                parentContext = scope.span().context();
            }
            if (parentContext instanceof DDSpanContext) {
                ddsc = (DDSpanContext)parentContext;
                traceId = ((DDSpanContext)ddsc).getTraceId();
                parentSpanId = ((DDSpanContext)ddsc).getSpanId();
                baggage = ((DDSpanContext)ddsc).getBaggageItems();
                parentTrace = ((DDSpanContext)ddsc).getTrace();
                samplingPriority = ((DDSpanContext)ddsc).getSamplingPriority();
                if (this.serviceName == null) {
                    this.serviceName = ((DDSpanContext)ddsc).getServiceName();
                }
                if (this.spanType == null) {
                    this.spanType = ((DDSpanContext)ddsc).getSpanType();
                }
            } else if (parentContext instanceof ExtractedContext) {
                ddsc = (ExtractedContext)parentContext;
                traceId = ((ExtractedContext)ddsc).getTraceId();
                parentSpanId = ((ExtractedContext)ddsc).getSpanId();
                baggage = ((ExtractedContext)ddsc).getBaggage();
                parentTrace = new PendingTrace(DDTracer.this, traceId);
                samplingPriority = ((ExtractedContext)ddsc).getSamplingPriority();
            } else {
                traceId = this.generateNewId();
                parentSpanId = 0L;
                baggage = null;
                parentTrace = new PendingTrace(DDTracer.this, traceId);
                samplingPriority = Integer.MIN_VALUE;
            }
            if (this.serviceName == null) {
                this.serviceName = DDTracer.this.serviceName;
            }
            String operationName = this.operationName != null ? this.operationName : this.resourceName;
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, this.serviceName, operationName, this.resourceName, samplingPriority, baggage, this.errorFlag, this.spanType, this.tags, parentTrace, DDTracer.this);
            return context;
        }
    }

    private static class CodecRegistry {
        private final Map<Format<?>, Codec<?>> codecs = new HashMap();

        private CodecRegistry() {
        }

        <T> Codec<T> get(Format<T> format) {
            return this.codecs.get(format);
        }

        public <T> void register(Format<T> format, Codec<T> codec) {
            this.codecs.put(format, codec);
        }
    }
}

