/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.opentracing.scopemanager.ScopeContext;
import datadog.trace.context.TraceScope;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.noop.NoopScopeManager;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScope
implements Scope,
TraceScope {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScope.class);
    final ContextualScopeManager scopeManager;
    final AtomicInteger refCount;
    private final Span wrapped;
    private final boolean finishOnClose;
    private final Scope toRestore;

    ContinuableScope(ContextualScopeManager scopeManager, Span wrapped, boolean finishOnClose) {
        this(scopeManager, new AtomicInteger(1), wrapped, finishOnClose);
    }

    private ContinuableScope(ContextualScopeManager scopeManager, AtomicInteger refCount, Span wrapped, boolean finishOnClose) {
        this.scopeManager = scopeManager;
        this.refCount = refCount;
        this.wrapped = wrapped;
        this.finishOnClose = finishOnClose;
        this.toRestore = scopeManager.tlsScope.get();
        scopeManager.tlsScope.set(this);
    }

    public void close() {
        if (this.scopeManager.tlsScope.get() != this) {
            return;
        }
        if (this.refCount.decrementAndGet() == 0 && this.finishOnClose) {
            this.wrapped.finish();
        }
        this.scopeManager.tlsScope.set(this.toRestore);
    }

    public Span span() {
        return this.wrapped;
    }

    public Continuation capture(boolean finishOnClose) {
        return new Continuation(this.finishOnClose && finishOnClose);
    }

    public class Continuation
    implements Closeable,
    TraceScope.Continuation {
        public WeakReference<Continuation> ref;
        private final AtomicBoolean used = new AtomicBoolean(false);
        private final PendingTrace trace;
        private final boolean finishSpanOnClose;

        private Continuation(boolean finishOnClose) {
            this.finishSpanOnClose = finishOnClose;
            ContinuableScope.this.refCount.incrementAndGet();
            if (ContinuableScope.this.wrapped.context() instanceof DDSpanContext) {
                DDSpanContext context = (DDSpanContext)ContinuableScope.this.wrapped.context();
                this.trace = context.getTrace();
                this.trace.registerContinuation(this);
            } else {
                this.trace = null;
            }
        }

        public ClosingScope activate() {
            if (this.used.compareAndSet(false, true)) {
                for (ScopeContext context : ContinuableScope.this.scopeManager.scopeContexts) {
                    if (!context.inContext()) continue;
                    return new ClosingScope(context.activate(ContinuableScope.this.wrapped, this.finishSpanOnClose));
                }
                return new ClosingScope(new ContinuableScope(ContinuableScope.this.scopeManager, ContinuableScope.this.refCount, ContinuableScope.this.wrapped, this.finishSpanOnClose));
            }
            log.debug("Reusing a continuation not allowed.  Returning no-op scope.");
            return new ClosingScope((Scope)NoopScopeManager.NoopScope.INSTANCE);
        }

        @Override
        public void close() {
            this.used.getAndSet(true);
            if (this.trace != null) {
                this.trace.cancelContinuation(this);
            }
        }

        private class ClosingScope
        implements Scope,
        TraceScope {
            private final Scope wrappedScope;

            private ClosingScope(Scope wrappedScope) {
                this.wrappedScope = wrappedScope;
            }

            public TraceScope.Continuation capture(boolean finishOnClose) {
                if (this.wrappedScope instanceof TraceScope) {
                    return ((TraceScope)this.wrappedScope).capture(finishOnClose);
                }
                log.debug("{} Failed to capture. ClosingScope does not wrap a TraceScope: {}.", (Object)this, (Object)this.wrappedScope);
                return null;
            }

            public void close() {
                this.wrappedScope.close();
                Continuation.this.close();
            }

            public Span span() {
                return this.wrappedScope.span();
            }
        }
    }
}

