/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import com.fasterxml.jackson.databind.JsonNode;
import datadog.opentracing.DDSpan;
import datadog.trace.common.sampling.AbstractSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDApi;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateByServiceSampler
implements Sampler,
DDApi.ResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceSampler.class);
    private static final String BASE_KEY = "service:,env:";
    private RateSampler baseSampler = new RateSampler(1.0);
    private final Map<String, RateSampler> serviceRates = new HashMap<String, RateSampler>();

    @Override
    public synchronized boolean sample(DDSpan span) {
        return true;
    }

    public void initializeSamplingPriority(DDSpan span) {
        if (span.isRootSpan()) {
            this.setSamplingPriorityOnSpanContext(span);
        } else if (span.getSamplingPriority() == null) {
            this.setSamplingPriorityOnSpanContext(span);
        }
    }

    private synchronized void setSamplingPriorityOnSpanContext(DDSpan span) {
        String serviceName = span.getServiceName();
        String env = RateByServiceSampler.getSpanEnv(span);
        String key = "service:" + serviceName + ",env:" + env;
        boolean agentSample = this.serviceRates.containsKey(key) ? this.serviceRates.get(key).sample(span) : this.baseSampler.sample(span);
        if (agentSample) {
            span.setSamplingPriority(1);
        } else {
            span.setSamplingPriority(0);
        }
    }

    private static String getSpanEnv(DDSpan span) {
        return null == span.getTags().get("env") ? "" : String.valueOf(span.getTags().get("env"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(String endpoint, JsonNode responseJson) {
        JsonNode newServiceRates = responseJson.get("rate_by_service");
        if (null != newServiceRates) {
            log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, (Object)responseJson);
            RateByServiceSampler rateByServiceSampler = this;
            synchronized (rateByServiceSampler) {
                this.serviceRates.clear();
                Iterator itr = newServiceRates.fieldNames();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    try {
                        float val = Float.parseFloat(newServiceRates.get(key).toString());
                        if (BASE_KEY.equals(key)) {
                            this.baseSampler = new RateSampler(val);
                            continue;
                        }
                        this.serviceRates.put(key, new RateSampler(val));
                    }
                    catch (NumberFormatException nfe) {
                        log.debug("Unable to parse new service rate {} -> {}", (Object)key, (Object)newServiceRates.get(key));
                    }
                }
            }
        }
    }

    private static class RateSampler
    extends AbstractSampler {
        private final double sampleRate;

        public RateSampler(String sampleRate) {
            this(sampleRate == null ? 1.0 : Double.valueOf(sampleRate));
        }

        public RateSampler(double sampleRate) {
            if (sampleRate <= 0.0) {
                sampleRate = 1.0;
                log.error("SampleRate is negative or null, disabling the sampler");
            } else if (sampleRate > 1.0) {
                sampleRate = 1.0;
            }
            this.sampleRate = sampleRate;
            log.debug("Initializing the RateSampler, sampleRate: {} %", (Object)(this.sampleRate * 100.0));
        }

        @Override
        public boolean doSample(DDSpan span) {
            boolean sample = Math.random() <= this.sampleRate;
            log.debug("{} - Span is sampled: {}", (Object)span, (Object)sample);
            return sample;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public String toString() {
            return "RateSampler { sampleRate=" + this.sampleRate + " }";
        }
    }
}

