/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.common.container.ContainerInfo;
import datadog.common.exec.CommonTaskExecutor;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.common.writer.ddagent.TraceMapperV0_4;
import datadog.trace.common.writer.ddagent.TraceMapperV0_5;
import datadog.trace.common.writer.ddagent.unixdomainsockets.UnixDomainSocketFactory;
import datadog.trace.core.DDTraceCoreInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi {
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final int CONNECT_TIMEOUT_MS = 1000;
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final String V3_ENDPOINT = "v0.3/traces";
    private static final String V4_ENDPOINT = "v0.4/traces";
    private static final String V5_ENDPOINT = "v0.5/traces";
    private static final long NANOSECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toNanos(5L);
    private static final String WILL_NOT_LOG_FOR_MESSAGE = "(Will not log errors for 5 minutes)";
    private final List<DDAgentResponseListener> responseListeners = new ArrayList<DDAgentResponseListener>();
    private final String[] endpoints;
    private long previousErrorLogNanos = System.nanoTime() - NANOSECONDS_BETWEEN_ERROR_LOG;
    private boolean logNextSuccess = false;
    private long totalTraces = 0L;
    private long receivedTraces = 0L;
    private long sentTraces = 0L;
    private long failedTraces = 0L;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Double.class})}));
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private static final Map<String, RequestBody> ENDPOINT_SNIFF_REQUESTS;
    private final String host;
    private final int port;
    private final String unixDomainSocketPath;
    private final long timeoutMillis;
    private OkHttpClient httpClient;
    private HttpUrl tracesUrl;
    private String detectedVersion = null;
    private boolean agentRunning = false;

    public DDAgentApi(String host, int port, String unixDomainSocketPath, long timeoutMillis, boolean enableV05Endpoint) {
        String[] stringArray;
        this.host = host;
        this.port = port;
        this.unixDomainSocketPath = unixDomainSocketPath;
        this.timeoutMillis = timeoutMillis;
        if (enableV05Endpoint) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.endpoints = stringArray;
    }

    public DDAgentApi(String host, int port, String unixDomainSocketPath, long timeoutMillis) {
        this(host, port, unixDomainSocketPath, timeoutMillis, true);
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    TraceMapper selectTraceMapper() {
        String endpoint = this.detectEndpointAndBuildClient();
        if (null == endpoint) {
            return null;
        }
        if (V5_ENDPOINT.equals(endpoint)) {
            return new TraceMapperV0_5();
        }
        return new TraceMapperV0_4();
    }

    /*
     * Loose catch block
     */
    Response sendSerializedTraces(Payload payload) {
        Object parsedResponse;
        String responseString;
        Throwable throwable;
        okhttp3.Response response;
        int sizeInBytes;
        block31: {
            block32: {
                block28: {
                    Response response2;
                    block29: {
                        block30: {
                            sizeInBytes = payload.sizeInBytes();
                            if (null == this.httpClient) {
                                this.detectEndpointAndBuildClient();
                                if (null == this.httpClient) {
                                    log.error("No datadog agent detected");
                                    this.countAndLogFailedSend(payload.traceCount(), payload.representativeCount(), sizeInBytes, null, null);
                                    return Response.failed(this.agentRunning ? 404 : 503);
                                }
                            }
                            Request request = DDAgentApi.prepareRequest(this.tracesUrl).addHeader(X_DATADOG_TRACE_COUNT, Integer.toString(payload.representativeCount())).put((RequestBody)new MsgPackRequestBody(payload)).build();
                            this.totalTraces += (long)payload.representativeCount();
                            this.receivedTraces += (long)payload.traceCount();
                            response = this.httpClient.newCall(request).execute();
                            throwable = null;
                            if (response.code() == 200) break block28;
                            this.countAndLogFailedSend(payload.traceCount(), payload.representativeCount(), sizeInBytes, response, null);
                            response2 = Response.failed(response.code());
                            if (response == null) break block29;
                            if (throwable == null) break block30;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block29;
                        }
                        response.close();
                    }
                    return response2;
                }
                this.countAndLogSuccessfulSend(payload.traceCount(), payload.representativeCount(), sizeInBytes);
                responseString = null;
                responseString = DDAgentApi.getResponseBody(response);
                if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                    parsedResponse = (Map)RESPONSE_ADAPTER.fromJson(responseString);
                    String endpoint = this.tracesUrl.toString();
                    for (DDAgentResponseListener listener : this.responseListeners) {
                        listener.onResponse(endpoint, (Map<String, Map<String, Number>>)parsedResponse);
                    }
                }
                parsedResponse = Response.success(response.code(), responseString);
                if (response == null) break block31;
                if (throwable == null) break block32;
                try {
                    response.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                break block31;
            }
            response.close();
        }
        return parsedResponse;
        {
            catch (IOException e) {
                Response response3;
                block33: {
                    block34: {
                        log.debug("Failed to parse DD agent response: {}", (Object)responseString, (Object)e);
                        response3 = Response.success(response.code(), e);
                        if (response == null) break block33;
                        if (throwable == null) break block34;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        break block33;
                    }
                    response.close();
                }
                return response3;
                {
                    catch (Throwable throwable5) {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (IOException e2) {
                            this.countAndLogFailedSend(payload.traceCount(), payload.representativeCount(), sizeInBytes, null, e2);
                            return Response.failed(e2);
                        }
                    }
                }
            }
        }
    }

    private void countAndLogSuccessfulSend(int traceCount, int representativeCount, int sizeInBytes) {
        this.sentTraces += (long)traceCount;
        if (log.isDebugEnabled()) {
            log.debug(this.createSendLogMessage(traceCount, representativeCount, sizeInBytes, "Success"));
        } else if (this.logNextSuccess) {
            this.logNextSuccess = false;
            if (log.isInfoEnabled()) {
                log.info(this.createSendLogMessage(traceCount, representativeCount, sizeInBytes, "Success"));
            }
        }
    }

    private void countAndLogFailedSend(int traceCount, int representativeCount, int sizeInBytes, okhttp3.Response response, IOException outer) {
        long now;
        this.failedTraces += (long)traceCount;
        boolean hasLogged = false;
        String agentError = DDAgentApi.getResponseBody(response);
        if (log.isDebugEnabled()) {
            String sendErrorString = this.createSendLogMessage(traceCount, representativeCount, sizeInBytes, agentError.isEmpty() ? "Error" : agentError);
            if (response != null) {
                log.debug("{} Status: {}, Response: {}, Body: {}", new Object[]{sendErrorString, response.code(), response.message(), agentError});
                hasLogged = true;
            } else if (outer != null) {
                log.debug(sendErrorString, (Throwable)outer);
                hasLogged = true;
            } else {
                log.debug(sendErrorString);
                hasLogged = true;
            }
        }
        if (!hasLogged && log.isWarnEnabled() && (now = System.nanoTime()) - this.previousErrorLogNanos >= NANOSECONDS_BETWEEN_ERROR_LOG) {
            this.previousErrorLogNanos = now;
            this.logNextSuccess = true;
            String sendErrorString = this.createSendLogMessage(traceCount, representativeCount, sizeInBytes, agentError.isEmpty() ? "Error" : agentError);
            if (response != null) {
                log.warn("{} Status: {} {} {}", new Object[]{sendErrorString, response.code(), response.message(), WILL_NOT_LOG_FOR_MESSAGE});
            } else if (outer != null) {
                log.warn("{} {}: {} {}", new Object[]{sendErrorString, outer.getClass().getName(), outer.getMessage(), WILL_NOT_LOG_FOR_MESSAGE});
            } else {
                log.warn("{} {}", (Object)sendErrorString, (Object)WILL_NOT_LOG_FOR_MESSAGE);
            }
        }
    }

    private static String getResponseBody(okhttp3.Response response) {
        if (response != null) {
            try {
                return response.body().string().trim();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return "";
    }

    private String createSendLogMessage(int traceCount, int representativeCount, int sizeInBytes, String prefix) {
        String sizeString = sizeInBytes > 1024 ? sizeInBytes / 1024 + "KB" : sizeInBytes + "B";
        return prefix + " while sending " + traceCount + " of " + representativeCount + " (size=" + sizeString + ") traces to the DD agent. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    private static OkHttpClient buildClientIfAvailable(String endpoint, HttpUrl url, String unixDomainSocketPath, long timeoutMillis) {
        OkHttpClient client = DDAgentApi.buildHttpClient(unixDomainSocketPath, timeoutMillis);
        try {
            return DDAgentApi.validateClient(endpoint, client, url);
        }
        catch (IOException e) {
            try {
                return DDAgentApi.validateClient(endpoint, client, url);
            }
            catch (IOException ignored) {
                log.debug("No connectivity to {}: {}", (Object)url, (Object)ignored.getMessage());
                return null;
            }
        }
    }

    private static OkHttpClient validateClient(String endpoint, OkHttpClient client, HttpUrl url) throws IOException {
        RequestBody body = ENDPOINT_SNIFF_REQUESTS.get(endpoint);
        Request request = DDAgentApi.prepareRequest(url).header(X_DATADOG_TRACE_COUNT, "0").put(body).build();
        try (okhttp3.Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                log.debug("connectivity to {} validated", (Object)url);
                OkHttpClient okHttpClient = client;
                return okHttpClient;
            }
            log.debug("connectivity to {} not validated, response code={}", (Object)url, (Object)response.code());
        }
        return null;
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath, long timeoutMillis) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder = builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        return builder.connectTimeout(1000L, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT)).dispatcher(new Dispatcher((ExecutorService)CommonTaskExecutor.INSTANCE)).build();
    }

    private static HttpUrl getUrl(String host, int port, String endPoint) {
        return new HttpUrl.Builder().scheme("http").host(host).port(port).addEncodedPathSegments(endPoint).build();
    }

    private static Request.Builder prepareRequest(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, DDTraceCoreInfo.JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, DDTraceCoreInfo.JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, DDTraceCoreInfo.JAVA_VM_VENDOR).addHeader(DATADOG_META_TRACER_VERSION, DDTraceCoreInfo.VERSION);
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId == null) {
            return builder;
        }
        return builder.addHeader(DATADOG_CONTAINER_ID, containerId);
    }

    String detectEndpointAndBuildClient() {
        if (this.httpClient == null) {
            this.agentRunning = this.isAgentRunning();
            for (String candidate : this.endpoints) {
                this.tracesUrl = DDAgentApi.getUrl(this.host, this.port, candidate);
                this.httpClient = DDAgentApi.buildClientIfAvailable(candidate, this.tracesUrl, this.unixDomainSocketPath, this.timeoutMillis);
                if (null != this.httpClient) {
                    this.detectedVersion = candidate;
                    log.debug("connected to agent {}", (Object)candidate);
                    return candidate;
                }
                log.debug("API {} endpoints not available. Downgrading", (Object)candidate);
            }
            if (null == this.tracesUrl) {
                log.error("no compatible agent detected");
            }
        } else {
            log.warn("No connectivity to datadog agent");
        }
        if (null == this.detectedVersion) {
            log.debug("Tried all of {}, no connectivity to datadog agent", (Object[])this.endpoints);
        }
        return this.detectedVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAgentRunning() {
        try (Socket socket = new Socket();){
            socket.setSoTimeout(1000);
            socket.connect(new InetSocketAddress(this.host, this.port));
            log.debug("Agent connectivity ({}:{})", (Object)this.host, (Object)this.port);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            log.debug("No agent connectivity ({}:{})", (Object)this.host, (Object)this.port);
            return false;
        }
    }

    static {
        HashMap<String, RequestBody> requests = new HashMap<String, RequestBody>();
        requests.put(V5_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_5.EMPTY));
        requests.put(V4_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_4.EMPTY));
        requests.put(V3_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_4.EMPTY));
        ENDPOINT_SNIFF_REQUESTS = Collections.unmodifiableMap(requests);
    }

    private static class MsgPackRequestBody
    extends RequestBody {
        private final Payload payload;

        private MsgPackRequestBody(Payload payload) {
            this.payload = payload;
        }

        public MediaType contentType() {
            return MSGPACK;
        }

        public long contentLength() {
            return this.payload.sizeInBytes();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.payload.writeTo((WritableByteChannel)sink);
        }
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;
        private final String response;

        public static Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static Response success(int status, String response) {
            return new Response(true, status, null, response);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception, null);
        }

        public static Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception, null);
        }

        private Response(boolean success, Integer status, Throwable exception, String response) {
            this.success = success;
            this.status = status;
            this.exception = exception;
            this.response = response;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }

        public final String response() {
            return this.response;
        }
    }
}

