/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.DDSpanData;
import datadog.trace.core.StringTables;
import datadog.trace.core.TagsAndBaggageConsumer;
import datadog.trace.core.serialization.msgpack.EncodingCachingStrategies;
import datadog.trace.core.serialization.msgpack.Util;
import datadog.trace.core.serialization.msgpack.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;

public final class TraceMapperV0_4
implements TraceMapper {
    static final byte[] EMPTY = ByteBuffer.allocate(1).put((byte)-112).array();
    private final byte[] numberByteArray = Util.integerToStringBuffer();

    @Override
    public void map(List<? extends DDSpanData> trace, final Writable writable) {
        writable.startArray(trace.size());
        for (DDSpanData dDSpanData : trace) {
            writable.startMap(12);
            writable.writeUTF8(StringTables.SERVICE);
            writable.writeString(dDSpanData.getServiceName(), EncodingCachingStrategies.CONSTANT_TAGS);
            writable.writeUTF8(StringTables.NAME);
            writable.writeObject(dDSpanData.getOperationName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.RESOURCE);
            writable.writeObject(dDSpanData.getResourceName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.TRACE_ID);
            writable.writeLong(dDSpanData.getTraceId().toLong());
            writable.writeUTF8(StringTables.SPAN_ID);
            writable.writeLong(dDSpanData.getSpanId().toLong());
            writable.writeUTF8(StringTables.PARENT_ID);
            writable.writeLong(dDSpanData.getParentId().toLong());
            writable.writeUTF8(StringTables.START);
            writable.writeLong(dDSpanData.getStartTime());
            writable.writeUTF8(StringTables.DURATION);
            writable.writeLong(dDSpanData.getDurationNano());
            writable.writeUTF8(StringTables.TYPE);
            writable.writeString(dDSpanData.getType(), EncodingCachingStrategies.CONSTANT_TAGS);
            writable.writeUTF8(StringTables.ERROR);
            writable.writeInt(dDSpanData.getError());
            writable.writeUTF8(StringTables.METRICS);
            writable.writeMap(dDSpanData.getMetrics(), EncodingCachingStrategies.CONSTANT_KEYS);
            writable.writeUTF8(StringTables.META);
            dDSpanData.processTagsAndBaggage(new TagsAndBaggageConsumer(){

                @Override
                public void accept(Map<String, Object> tags, Map<String, String> baggage) {
                    int size = tags.size();
                    boolean overlap = false;
                    if (baggage.size() > 0) {
                        for (String string : baggage.keySet()) {
                            if (!tags.containsKey(string)) {
                                ++size;
                                continue;
                            }
                            overlap = true;
                        }
                    }
                    writable.startMap(size);
                    for (Map.Entry entry : baggage.entrySet()) {
                        if (overlap && tags.containsKey(entry.getKey())) continue;
                        writable.writeString((CharSequence)entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                        writable.writeObject(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
                    }
                    for (Map.Entry entry : tags.entrySet()) {
                        writable.writeString((CharSequence)entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                        if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer) {
                            Util.writeLongAsString(((Number)entry.getValue()).longValue(), writable, TraceMapperV0_4.this.numberByteArray);
                            continue;
                        }
                        if (entry.getValue() instanceof UTF8BytesString) {
                            writable.writeObject(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
                            continue;
                        }
                        writable.writeString(String.valueOf(entry.getValue()), EncodingCachingStrategies.NO_CACHING);
                    }
                }
            });
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return 0x500000;
    }

    @Override
    public void reset() {
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        int sizeInBytes() {
            return PayloadV0_4.sizeInBytes(this.body);
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            PayloadV0_4.writeBufferToChannel(this.body, channel);
        }
    }
}

