/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import datadog.common.container.ServerlessInfo;
import datadog.trace.api.Config;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.DDId;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.LoggingWriter;
import datadog.trace.common.writer.PrintingWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.DDTraceCoreInfo;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.StatusLogger;
import datadog.trace.core.jfr.DDNoopScopeEventFactory;
import datadog.trace.core.jfr.DDScopeEventFactory;
import datadog.trace.core.monitor.Monitor;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContext;
import datadog.trace.core.scopemanager.ContinuableScopeManager;
import datadog.trace.core.taginterceptor.AbstractTagInterceptor;
import datadog.trace.core.taginterceptor.TagInterceptorsFactory;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements AgentTracer.TracerAPI {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    public static final BigInteger TRACE_ID_MIN = BigInteger.ZERO;
    public static final String LANG_STATSD_TAG = "lang";
    public static final String LANG_VERSION_STATSD_TAG = "lang_version";
    public static final String LANG_INTERPRETER_STATSD_TAG = "lang_interpreter";
    public static final String LANG_INTERPRETER_VENDOR_STATSD_TAG = "lang_interpreter_vendor";
    public static final String TRACER_VERSION_STATSD_TAG = "tracer_version";
    final String serviceName;
    final Writer writer;
    final Sampler sampler;
    final AgentScopeManager scopeManager;
    private final Map<String, String> localRootSpanTags;
    private final Map<String, String> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final Thread shutdownCallback;
    private final Map<String, List<AbstractTagInterceptor>> spanTagInterceptors = new HashMap<String, List<AbstractTagInterceptor>>();
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;

    @Override
    public TraceScope.Continuation capture() {
        TraceScope activeScope = this.activeScope();
        return activeScope == null ? null : activeScope.capture();
    }

    private CoreTracer(Config config, String serviceName, Writer writer, Sampler sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, AgentScopeManager scopeManager, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans, StatsDClient statsDClient) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.serviceName = serviceName;
        this.sampler = sampler;
        this.injector = injector;
        this.extractor = extractor;
        this.localRootSpanTags = localRootSpanTags;
        this.defaultSpanTags = defaultSpanTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        this.statsDClient = statsDClient == null ? CoreTracer.createStatsDClient(config) : statsDClient;
        this.scopeManager = scopeManager == null ? new ContinuableScopeManager(config.getScopeDepthLimit(), CoreTracer.createScopeEventFactory(), this.statsDClient, config.isScopeStrictMode()) : scopeManager;
        this.writer = writer == null ? CoreTracer.createWriter(config, sampler, this.statsDClient) : writer;
        this.writer.start();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        log.info("New instance: {}", (Object)this);
        List<AbstractTagInterceptor> tagInterceptors = TagInterceptorsFactory.createTagInterceptors();
        for (AbstractTagInterceptor interceptor : tagInterceptors) {
            this.addTagInterceptor(interceptor);
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        PendingTrace.initialize();
        StatusLogger.logStatus(config);
    }

    public void finalize() {
        try {
            this.shutdownCallback.run();
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            log.error("Error while finalizing DDTracer.", (Throwable)e);
        }
    }

    public List<AbstractTagInterceptor> getSpanTagInterceptors(String tag) {
        return this.spanTagInterceptors.get(tag);
    }

    private void addTagInterceptor(AbstractTagInterceptor interceptor) {
        List<AbstractTagInterceptor> list = this.spanTagInterceptors.get(interceptor.getMatchingTag());
        if (list == null) {
            list = new ArrayList<AbstractTagInterceptor>();
        }
        list.add(interceptor);
        this.spanTagInterceptors.put(interceptor.getMatchingTag(), list);
        log.debug("Decorator added: '{}' -> {}", (Object)interceptor.getMatchingTag(), (Object)interceptor.getClass().getName());
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    @Override
    public CoreSpanBuilder buildSpan(String operationName) {
        return new CoreSpanBuilder(operationName);
    }

    @Override
    public AgentSpan startSpan(String spanName) {
        return this.buildSpan(spanName).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, long startTimeMicros) {
        return this.buildSpan(spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span, ScopeSource.INSTRUMENTATION);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.activate(span, source);
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public TraceScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter);
    }

    @Override
    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        DDSpan rootSpan = ddSpanContext.getTrace().getRootSpan();
        this.setSamplingPriorityIfNecessary(rootSpan);
        this.injector.inject(ddSpanContext, carrier, setter);
    }

    @Override
    public <C> AgentSpan.Context extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.extractor.extract(carrier, getter);
    }

    void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            return;
        }
        List<DDSpan> writtenTrace = trace;
        if (!this.interceptors.isEmpty()) {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
            }
            writtenTrace = new ArrayList<DDSpan>(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        if (!writtenTrace.isEmpty()) {
            DDSpan spanToSample;
            DDSpan rootSpan = writtenTrace.get(0).getLocalRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            DDSpan dDSpan = spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
            if (this.sampler.sample(spanToSample)) {
                this.writer.write(writtenTrace);
            } else {
                this.incrementTraceCount();
            }
        }
    }

    void setSamplingPriorityIfNecessary(DDSpan rootSpan) {
        if (this.sampler instanceof PrioritySampler && rootSpan != null && rootSpan.context().getSamplingPriority() == Integer.MIN_VALUE) {
            ((PrioritySampler)((Object)this.sampler)).setSamplingPriority(rootSpan);
        }
    }

    void incrementTraceCount() {
        this.writer.incrementTraceCount();
    }

    public String getTraceId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getTraceId().toString();
        }
        return "0";
    }

    public String getSpanId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId().toString();
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void close() {
        PendingTrace.close();
        this.writer.close();
    }

    public String toString() {
        return "DDTracer-" + Integer.toHexString(this.hashCode()) + "{ serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", defaultSpanTags=" + this.defaultSpanTags + '}';
    }

    private static DDScopeEventFactory createScopeEventFactory() {
        try {
            return (DDScopeEventFactory)Class.forName("datadog.trace.core.jfr.openjdk.ScopeEventFactory").newInstance();
        }
        catch (ClassFormatError | NoClassDefFoundError | ReflectiveOperationException e) {
            log.debug("Profiling of ScopeEvents is not available");
            return new DDNoopScopeEventFactory();
        }
    }

    private static Writer createWriter(Config config, Sampler sampler, StatsDClient statsDClient) {
        String configuredType = config.getWriterType();
        if ("LoggingWriter".equals(configuredType)) {
            return new LoggingWriter();
        }
        if ("PrintingWriter".equals(configuredType)) {
            return new PrintingWriter(System.out, true);
        }
        if (!"DDAgentWriter".equals(configuredType)) {
            log.warn("Writer type not configured correctly: Type {} not recognized. Ignoring", (Object)configuredType);
        }
        if (config.isAgentConfiguredUsingDefault() && ServerlessInfo.get().isRunningInServerlessEnvironment()) {
            log.info("Detected serverless environment.  Using PrintingWriter");
            return new PrintingWriter(System.out, true);
        }
        String unixDomainSocket = config.getAgentUnixDomainSocket();
        if (unixDomainSocket != ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET && CoreTracer.isWindows()) {
            log.warn("{} setting not supported on {}.  Reverting to the default.", (Object)"trace.agent.unix.domain.socket", (Object)System.getProperty("os.name"));
            unixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
        }
        DDAgentApi ddAgentApi = new DDAgentApi(config.getAgentHost(), config.getAgentPort(), unixDomainSocket, TimeUnit.SECONDS.toMillis(config.getAgentTimeout()));
        DDAgentWriter ddAgentWriter = DDAgentWriter.builder().agentApi(ddAgentApi).monitor(new Monitor(statsDClient)).build();
        if (sampler instanceof DDAgentResponseListener) {
            ddAgentWriter.addResponseListener((DDAgentResponseListener)((Object)sampler));
        }
        return ddAgentWriter;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    private static StatsDClient createStatsDClient(Config config) {
        Integer port;
        if (!config.isHealthMetricsEnabled()) {
            return new NoOpStatsDClient();
        }
        String host = config.getHealthMetricsStatsdHost();
        if (host == null) {
            host = config.getJmxFetchStatsdHost();
        }
        if (host == null) {
            host = config.getAgentHost();
        }
        if ((port = config.getHealthMetricsStatsdPort()) == null) {
            port = config.getJmxFetchStatsdPort();
        }
        String[] constantTags = new String[]{CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, "java"), CoreTracer.statsdTag(LANG_VERSION_STATSD_TAG, DDTraceCoreInfo.JAVA_VERSION), CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_NAME), CoreTracer.statsdTag(LANG_INTERPRETER_VENDOR_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_VENDOR), CoreTracer.statsdTag(TRACER_VERSION_STATSD_TAG, DDTraceCoreInfo.VERSION)};
        return new NonBlockingStatsDClient("datadog.tracer", host, port.intValue(), constantTags);
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    public static CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super("dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        private final String operationName;
        private Map<String, Object> tags;
        private long timestampMicro;
        private Object parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private String spanType;
        private boolean ignoreScope = false;

        public CoreSpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            return DDSpan.create(this.timestampMicro, this.buildSpanContext());
        }

        @Override
        public AgentSpan start() {
            DDSpan span = this.buildSpan();
            return span;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public CoreSpanBuilder withSpanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Object value) {
            Map<String, Object> tagMap = this.tags;
            if (tagMap == null) {
                this.tags = tagMap = new LinkedHashMap<String, Object>();
            }
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                tagMap.remove(tag);
            } else {
                tagMap.put(tag, value);
            }
            return this;
        }

        private DDSpanContext buildSpanContext() {
            Map rootSpanTags;
            Map<String, String> coreTags;
            String origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            DDId parentSpanId;
            DDId traceId;
            AgentSpan activeSpan;
            DDId spanId = DDId.generate();
            Object parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            if (parentContext instanceof DDSpanContext) {
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = Integer.MIN_VALUE;
                origin = null;
                coreTags = null;
                rootSpanTags = null;
                if (this.serviceName == null) {
                    this.serviceName = ddsc.getServiceName();
                }
            } else {
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    baggage = extractedContext.getBaggage();
                } else {
                    traceId = DDId.generate();
                    parentSpanId = DDId.ZERO;
                    samplingPriority = Integer.MIN_VALUE;
                    baggage = null;
                }
                if (parentContext instanceof TagContext) {
                    coreTags = ((TagContext)parentContext).getTags();
                    origin = ((TagContext)parentContext).getOrigin();
                } else {
                    coreTags = null;
                    origin = null;
                }
                rootSpanTags = CoreTracer.this.localRootSpanTags;
                parentTrace = PendingTrace.create(CoreTracer.this, traceId);
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            String operationName = this.operationName != null ? this.operationName : this.resourceName;
            int tagsSize = (null == this.tags ? 0 : this.tags.size()) + CoreTracer.this.defaultSpanTags.size() + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size());
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, tagsSize, parentTrace, CoreTracer.this, CoreTracer.this.serviceNameMappings);
            context.setAllTags(CoreTracer.this.defaultSpanTags);
            context.setAllTags(this.tags);
            context.setAllTags(coreTags);
            context.setAllTags(rootSpanTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private Writer writer;
        private Sampler sampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private AgentScopeManager scopeManager;
        private Map<String, String> localRootSpanTags;
        private Map<String, String> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private int partialFlushMinSpans;
        private StatsDClient statsDClient;

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config));
            this.injector(HttpCodec.createInjector(config));
            this.extractor(HttpCodec.createExtractor(config, config.getHeaderTags()));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getHeaderTags());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            return this;
        }

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder scopeManager(AgentScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, String> localRootSpanTags) {
            this.localRootSpanTags = localRootSpanTags;
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, String> defaultSpanTags) {
            this.defaultSpanTags = defaultSpanTags;
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = serviceNameMappings;
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = taggedHeaders;
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.writer, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.partialFlushMinSpans, this.statsDClient);
        }

        public String toString() {
            return "CoreTracer.CoreTracerBuilder(config=" + this.config + ", serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", injector=" + this.injector + ", extractor=" + this.extractor + ", scopeManager=" + this.scopeManager + ", localRootSpanTags=" + this.localRootSpanTags + ", defaultSpanTags=" + this.defaultSpanTags + ", serviceNameMappings=" + this.serviceNameMappings + ", taggedHeaders=" + this.taggedHeaders + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ", statsDClient=" + this.statsDClient + ")";
        }
    }
}

