/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

public class FixedSizeCache<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int mask;
    private final Node<K, V>[] elements;

    public FixedSizeCache(int capacity) {
        int n;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be > 0");
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        n = (n = -1 >>> Integer.numberOfLeadingZeros(capacity - 1)) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        Node[] lmnts = new Node[n];
        this.elements = lmnts;
        this.mask = n - 1;
    }

    public V computeIfAbsent(K key, Creator<K, ? extends V> creator) {
        if (key == null) {
            return null;
        }
        int h = key.hashCode();
        int firstPos = h & this.mask;
        Object value = null;
        for (int i = 1; i <= 3; ++i) {
            int pos = h & this.mask;
            Node<K, V> current = this.elements[pos];
            if (current == null) {
                value = this.createAndStoreValue(key, creator, pos);
                break;
            }
            if (key.equals(((Node)current).key)) {
                value = ((Node)current).value;
                break;
            }
            if (i == 3) {
                value = this.createAndStoreValue(key, creator, firstPos);
                break;
            }
            h = this.rehash(h);
        }
        return (V)value;
    }

    private V createAndStoreValue(K key, Creator<K, ? extends V> creator, int pos) {
        V value = creator.create(key);
        Node node = new Node(key, value);
        this.elements[pos] = node;
        return value;
    }

    private int rehash(int v) {
        int h = v * -1640532531;
        h = Integer.reverseBytes(h);
        return h * -1640532531;
    }

    private static final class Node<K, V> {
        private final K key;
        private final V value;

        private Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class LowerCase
    implements Creator<String, String> {
        @Override
        public String create(String key) {
            return key.toLowerCase();
        }
    }

    public static final class Suffix
    implements Creator<String, String> {
        private final String suffix;

        public Suffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public String create(String key) {
            return key + this.suffix;
        }
    }

    public static interface Creator<K, V> {
        public V create(K var1);
    }
}

