/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.DDSpanData;
import datadog.trace.core.monitor.Monitor;
import datadog.trace.core.serialization.msgpack.ByteBufferConsumer;
import datadog.trace.core.serialization.msgpack.Packer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadDispatcher
implements ByteBufferConsumer {
    private static final Logger log = LoggerFactory.getLogger(PayloadDispatcher.class);
    private final AtomicInteger droppedCount = new AtomicInteger();
    private final DDAgentApi api;
    private final Monitor monitor;
    private TraceMapper traceMapper;
    private Packer packer;

    public PayloadDispatcher(DDAgentApi api, Monitor monitor) {
        this.api = api;
        this.monitor = monitor;
    }

    void flush() {
        if (null != this.packer) {
            this.packer.flush();
        }
    }

    public void onTraceDropped() {
        this.droppedCount.incrementAndGet();
    }

    void addTrace(List<? extends DDSpanData> trace) {
        this.selectTraceMapper();
        if (null != this.traceMapper) {
            this.packer.format(trace, this.traceMapper);
        } else {
            this.onTraceDropped();
            log.debug("dropping {} traces because no agent was detected", (Object)1);
        }
    }

    private void selectTraceMapper() {
        if (null == this.traceMapper) {
            this.traceMapper = this.api.selectTraceMapper();
            if (null != this.traceMapper && null == this.packer) {
                this.packer = new Packer(this, ByteBuffer.allocate(this.traceMapper.messageBufferSize()));
            }
        }
    }

    @Override
    public void accept(int messageCount, ByteBuffer buffer) {
        if (messageCount > 0) {
            int representativeCount = this.droppedCount.getAndSet(0) + messageCount;
            Payload payload = this.traceMapper.newPayload().withRepresentativeCount(representativeCount).withBody(messageCount, buffer);
            int sizeInBytes = payload.sizeInBytes();
            this.monitor.onSerialize(sizeInBytes);
            DDAgentApi.Response response = this.api.sendSerializedTraces(payload);
            this.traceMapper.reset();
            if (response.success()) {
                if (log.isDebugEnabled()) {
                    log.debug("Successfully sent {} traces to the API", (Object)messageCount);
                }
                this.monitor.onSend(representativeCount, sizeInBytes, response);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to send {} traces (representing {}) of size {} bytes to the API", new Object[]{messageCount, representativeCount, sizeInBytes});
                }
                this.monitor.onFailedSend(representativeCount, sizeInBytes, response);
            }
        }
    }
}

