/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.core.DDSpan;
import java.util.List;

public class Monitor {
    private final StatsDClient statsd;

    public Monitor(StatsDClient statsd) {
        this.statsd = statsd;
    }

    public void onStart(int queueCapacity) {
        this.statsd.recordGaugeValue("queue.max_length", (long)queueCapacity, new String[0]);
    }

    public void onShutdown(boolean flushSuccess) {
    }

    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        this.statsd.incrementCounter("queue.accepted", new String[]{String.valueOf(samplingPriority)});
        this.statsd.count("queue.accepted_lengths", (long)trace.size(), new String[0]);
    }

    public void onFailedPublish(int samplingPriority) {
        this.statsd.incrementCounter("queue.dropped", new String[]{String.valueOf(samplingPriority)});
    }

    public void onScheduleFlush(boolean previousIncomplete) {
    }

    public void onFlush(boolean early) {
    }

    public void onSerialize(int serializedSizeInBytes) {
        this.statsd.count("queue.accepted_size", (long)serializedSizeInBytes, new String[0]);
    }

    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
    }

    public void onSend(int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(representativeCount, sizeInBytes, response);
    }

    public void onFailedSend(int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(representativeCount, sizeInBytes, response);
    }

    private void onSendAttempt(int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        this.statsd.incrementCounter("api.requests", new String[0]);
        this.statsd.recordGaugeValue("queue.length", (long)representativeCount, new String[0]);
        this.statsd.recordGaugeValue("queue.size", (long)sizeInBytes, new String[0]);
        if (response.exception() != null) {
            this.statsd.incrementCounter("api.errors", new String[0]);
        }
        if (response.status() != null) {
            this.statsd.incrementCounter("api.responses", new String[]{"status: " + response.status()});
        }
    }
}

