/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.core.monitor.Utils;

public class Counter {
    private final String name;
    private final String[] tags;
    private final StatsDClient statsd;

    Counter(String name, String[] tags, StatsDClient statsd) {
        this.name = name;
        this.tags = tags;
        this.statsd = statsd;
    }

    Counter(String name, StatsDClient statsd) {
        this.name = name;
        this.tags = new String[0];
        this.statsd = statsd;
    }

    public void increment(int delta) {
        this.statsd.count(this.name, (long)delta, this.tags);
    }

    public void incrementErrorCount(String cause, int delta) {
        this.statsd.count(this.name, (long)delta, Utils.mergeTags(this.tags, new String[]{"cause:" + cause.replace(' ', '_')}));
    }
}

