/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.PropagationStyle;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    public static final String CONFIGURATION_FILE = "trace.config";
    public static final String API_KEY = "api-key";
    public static final String API_KEY_FILE = "api-key-file";
    public static final String SITE = "site";
    public static final String SERVICE_NAME = "service.name";
    public static final String TRACE_ENABLED = "trace.enabled";
    public static final String INTEGRATIONS_ENABLED = "integrations.enabled";
    public static final String ID_GENERATION_STRATEGY = "id.generation.strategy";
    public static final String WRITER_TYPE = "writer.type";
    public static final String PRIORITIZATION_TYPE = "prioritization.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String TRACE_AGENT_PORT = "trace.agent.port";
    public static final String AGENT_PORT_LEGACY = "agent.port";
    public static final String AGENT_UNIX_DOMAIN_SOCKET = "trace.agent.unix.domain.socket";
    public static final String AGENT_TIMEOUT = "trace.agent.timeout";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    public static final String PRIORITY_SAMPLING_FORCE = "priority.sampling.force";
    @Deprecated
    public static final String TRACE_RESOLVER_ENABLED = "trace.resolver.enabled";
    public static final String SERVICE_MAPPING = "service.mapping";
    private static final String ENV = "env";
    private static final String VERSION = "version";
    public static final String TAGS = "tags";
    @Deprecated
    public static final String GLOBAL_TAGS = "trace.global.tags";
    public static final String SPAN_TAGS = "trace.span.tags";
    public static final String JMX_TAGS = "trace.jmx.tags";
    public static final String TRACE_ANALYTICS_ENABLED = "trace.analytics.enabled";
    public static final String TRACE_ANNOTATIONS = "trace.annotations";
    public static final String TRACE_EXECUTORS_ALL = "trace.executors.all";
    public static final String TRACE_EXECUTORS = "trace.executors";
    public static final String TRACE_METHODS = "trace.methods";
    public static final String TRACE_CLASSES_EXCLUDE = "trace.classes.exclude";
    public static final String TRACE_SAMPLING_SERVICE_RULES = "trace.sampling.service.rules";
    public static final String TRACE_SAMPLING_OPERATION_RULES = "trace.sampling.operation.rules";
    public static final String TRACE_SAMPLE_RATE = "trace.sample.rate";
    public static final String TRACE_RATE_LIMIT = "trace.rate.limit";
    public static final String TRACE_REPORT_HOSTNAME = "trace.report-hostname";
    public static final String HEADER_TAGS = "trace.header.tags";
    public static final String HTTP_SERVER_ERROR_STATUSES = "http.server.error.statuses";
    public static final String HTTP_CLIENT_ERROR_STATUSES = "http.client.error.statuses";
    public static final String HTTP_SERVER_TAG_QUERY_STRING = "http.server.tag.query-string";
    public static final String HTTP_CLIENT_TAG_QUERY_STRING = "http.client.tag.query-string";
    public static final String HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN = "trace.http.client.split-by-domain";
    public static final String DB_CLIENT_HOST_SPLIT_BY_INSTANCE = "trace.db.client.split-by-instance";
    public static final String SPLIT_BY_TAGS = "trace.split-by-tags";
    public static final String SCOPE_DEPTH_LIMIT = "trace.scope.depth.limit";
    public static final String SCOPE_STRICT_MODE = "trace.scope.strict.mode";
    public static final String PARTIAL_FLUSH_MIN_SPANS = "trace.partial.flush.min.spans";
    public static final String RUNTIME_CONTEXT_FIELD_INJECTION = "trace.runtime.context.field.injection";
    public static final String PROPAGATION_STYLE_EXTRACT = "propagation.style.extract";
    public static final String PROPAGATION_STYLE_INJECT = "propagation.style.inject";
    public static final String JMX_FETCH_ENABLED = "jmxfetch.enabled";
    public static final String JMX_FETCH_CONFIG_DIR = "jmxfetch.config.dir";
    public static final String JMX_FETCH_CONFIG = "jmxfetch.config";
    @Deprecated
    public static final String JMX_FETCH_METRICS_CONFIGS = "jmxfetch.metrics-configs";
    public static final String JMX_FETCH_CHECK_PERIOD = "jmxfetch.check-period";
    public static final String JMX_FETCH_REFRESH_BEANS_PERIOD = "jmxfetch.refresh-beans-period";
    public static final String JMX_FETCH_STATSD_HOST = "jmxfetch.statsd.host";
    public static final String JMX_FETCH_STATSD_PORT = "jmxfetch.statsd.port";
    public static final String HEALTH_METRICS_ENABLED = "trace.health.metrics.enabled";
    public static final String HEALTH_METRICS_STATSD_HOST = "trace.health.metrics.statsd.host";
    public static final String HEALTH_METRICS_STATSD_PORT = "trace.health.metrics.statsd.port";
    public static final String PERF_METRICS_ENABLED = "trace.perf.metrics.enabled";
    public static final String LOGS_INJECTION_ENABLED = "logs.injection";
    public static final String PROFILING_ENABLED = "profiling.enabled";
    @Deprecated
    public static final String PROFILING_URL = "profiling.url";
    @Deprecated
    public static final String PROFILING_API_KEY_OLD = "profiling.api-key";
    @Deprecated
    public static final String PROFILING_API_KEY_FILE_OLD = "profiling.api-key-file";
    @Deprecated
    public static final String PROFILING_API_KEY_VERY_OLD = "profiling.apikey";
    @Deprecated
    public static final String PROFILING_API_KEY_FILE_VERY_OLD = "profiling.apikey.file";
    public static final String PROFILING_TAGS = "profiling.tags";
    public static final String PROFILING_START_DELAY = "profiling.start-delay";
    public static final String PROFILING_START_FORCE_FIRST = "profiling.experimental.start-force-first";
    public static final String PROFILING_UPLOAD_PERIOD = "profiling.upload.period";
    public static final String PROFILING_TEMPLATE_OVERRIDE_FILE = "profiling.jfr-template-override-file";
    public static final String PROFILING_UPLOAD_TIMEOUT = "profiling.upload.timeout";
    public static final String PROFILING_UPLOAD_COMPRESSION = "profiling.upload.compression";
    public static final String PROFILING_PROXY_HOST = "profiling.proxy.host";
    public static final String PROFILING_PROXY_PORT = "profiling.proxy.port";
    public static final String PROFILING_PROXY_USERNAME = "profiling.proxy.username";
    public static final String PROFILING_PROXY_PASSWORD = "profiling.proxy.password";
    public static final String PROFILING_EXCEPTION_SAMPLE_LIMIT = "profiling.exception.sample.limit";
    public static final String PROFILING_EXCEPTION_HISTOGRAM_TOP_ITEMS = "profiling.exception.histogram.top-items";
    public static final String PROFILING_EXCEPTION_HISTOGRAM_MAX_COLLECTION_SIZE = "profiling.exception.histogram.max-collection-size";
    public static final String KAFKA_CLIENT_PROPAGATION_ENABLED = "kafka.client.propagation.enabled";
    public static final String KAFKA_CLIENT_BASE64_DECODING_ENABLED = "kafka.client.base64.decoding.enabled";
    private static final String PROFILING_REMOTE_URL_TEMPLATE = "https://intake.profile.%s/v1/input";
    private static final String PROFILING_LOCAL_URL_TEMPLATE = "http://%s:%d/profiling/v1/input";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String SPLIT_BY_SPACE_OR_COMMA_REGEX = "[,\\s]+";
    private final String runtimeId;
    private final String apiKey;
    private final String site;
    private final String serviceName;
    private final boolean traceEnabled;
    private final boolean integrationsEnabled;
    private final String writerType;
    private final String prioritizationType;
    private final boolean agentConfiguredUsingDefault;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final int agentTimeout;
    private final boolean prioritySamplingEnabled;
    private final String prioritySamplingForce;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    @NonNull
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final List<String> excludedClasses;
    private final Map<String, String> headerTags;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final Set<String> splitByTags;
    private final int scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final int partialFlushMinSpans;
    private final boolean runtimeContextFieldInjection;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean perfMetricsEnabled;
    private final boolean logsInjectionEnabled;
    private final boolean logsMDCTagsInjectionEnabled;
    private final boolean reportHostName;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final boolean traceAnalyticsEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final Double traceSampleRate;
    private final Double traceRateLimit;
    private final boolean profilingEnabled;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean kafkaClientPropagationEnabled;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean hystrixTagsEnabled;
    private final boolean servletPrincipalEnabled;
    private final boolean servletAsyncTimeoutError;
    private final boolean traceAgentV05Enabled;
    private final boolean debugEnabled;
    private final String configFile;
    private final IdGenerationStrategy idGenerationStrategy;
    private final ConfigProvider configProvider;
    private static final String PREFIX = "dd.";
    private static final Config INSTANCE = new Config();

    private String profilingApiKeyMasker() {
        return this.apiKey != null ? "****" : null;
    }

    private String profilingProxyPasswordMasker() {
        return this.profilingProxyPassword != null ? "****" : null;
    }

    private Config() {
        this(INSTANCE != null ? Config.INSTANCE.runtimeId : UUID.randomUUID().toString(), ConfigProvider.createDefault());
    }

    private Config(String runtimeId, ConfigProvider configProvider) {
        boolean socketConfiguredUsingDefault;
        boolean agentHostConfiguredUsingDefault;
        String agentHostFromEnvironment;
        this.configProvider = configProvider;
        this.configFile = Config.findConfigurationFile();
        this.runtimeId = runtimeId;
        String apiKeyFile = configProvider.getString(API_KEY_FILE);
        String tmpApiKey = configProvider.getStringBypassSysProps(API_KEY, null);
        if (apiKeyFile != null) {
            try {
                tmpApiKey = new String(Files.readAllBytes(Paths.get(apiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping", (Object)apiKeyFile, (Object)e);
            }
        }
        this.site = configProvider.getString(SITE, "datadoghq.com", new String[0]);
        this.serviceName = configProvider.getString("service", "unnamed-java-app", SERVICE_NAME);
        this.traceEnabled = configProvider.getBoolean(TRACE_ENABLED, true);
        this.integrationsEnabled = configProvider.getBoolean(INTEGRATIONS_ENABLED, true);
        this.writerType = configProvider.getString(WRITER_TYPE, "DDAgentWriter", new String[0]);
        this.prioritizationType = configProvider.getString(PRIORITIZATION_TYPE, "FastLane", new String[0]);
        this.idGenerationStrategy = configProvider.getEnum(ID_GENERATION_STRATEGY, IdGenerationStrategy.class, IdGenerationStrategy.RANDOM);
        if (this.idGenerationStrategy != IdGenerationStrategy.RANDOM) {
            log.warn("*** you are using an unsupported id generation strategy {} - this can impact correctness of traces", (Object)this.idGenerationStrategy);
        }
        if ((agentHostFromEnvironment = configProvider.getString(AGENT_HOST)) == null) {
            this.agentHost = "localhost";
            agentHostConfiguredUsingDefault = true;
        } else {
            this.agentHost = agentHostFromEnvironment;
            agentHostConfiguredUsingDefault = false;
        }
        String unixDomainFromEnv = configProvider.getString(AGENT_UNIX_DOMAIN_SOCKET);
        if (unixDomainFromEnv == null) {
            this.agentUnixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
            socketConfiguredUsingDefault = true;
        } else {
            this.agentUnixDomainSocket = unixDomainFromEnv;
            socketConfiguredUsingDefault = false;
        }
        this.agentPort = configProvider.getInteger(TRACE_AGENT_PORT, 8126, AGENT_PORT_LEGACY);
        this.agentConfiguredUsingDefault = agentHostConfiguredUsingDefault && socketConfiguredUsingDefault && this.agentPort == 8126;
        this.agentTimeout = configProvider.getInteger(AGENT_TIMEOUT, 10, new String[0]);
        this.prioritySamplingEnabled = configProvider.getBoolean(PRIORITY_SAMPLING, true);
        this.prioritySamplingForce = configProvider.getString(PRIORITY_SAMPLING_FORCE, ConfigDefaults.DEFAULT_PRIORITY_SAMPLING_FORCE, new String[0]);
        this.traceResolverEnabled = configProvider.getBoolean(TRACE_RESOLVER_ENABLED, true);
        this.serviceMapping = configProvider.getMergedMap(SERVICE_MAPPING);
        HashMap<String, String> tags = new HashMap<String, String>(configProvider.getMergedMap(GLOBAL_TAGS));
        tags.putAll(configProvider.getMergedMap(TAGS));
        this.tags = this.getMapWithPropertiesDefinedByEnvironment(tags, ENV, VERSION);
        this.spanTags = configProvider.getMergedMap(SPAN_TAGS);
        this.jmxTags = configProvider.getMergedMap(JMX_TAGS);
        this.excludedClasses = configProvider.getList(TRACE_CLASSES_EXCLUDE);
        this.headerTags = configProvider.getMergedMap(HEADER_TAGS);
        this.httpServerErrorStatuses = configProvider.getIntegerRange(HTTP_SERVER_ERROR_STATUSES, ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = configProvider.getIntegerRange(HTTP_CLIENT_ERROR_STATUSES, ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = configProvider.getBoolean(HTTP_SERVER_TAG_QUERY_STRING, false);
        this.httpClientTagQueryString = configProvider.getBoolean(HTTP_CLIENT_TAG_QUERY_STRING, false);
        this.httpClientSplitByDomain = configProvider.getBoolean(HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, false);
        this.dbClientSplitByInstance = configProvider.getBoolean(DB_CLIENT_HOST_SPLIT_BY_INSTANCE, false);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(configProvider.getList(SPLIT_BY_TAGS)));
        this.scopeDepthLimit = configProvider.getInteger(SCOPE_DEPTH_LIMIT, 100, new String[0]);
        this.scopeStrictMode = configProvider.getBoolean(SCOPE_STRICT_MODE, false);
        this.partialFlushMinSpans = configProvider.getInteger(PARTIAL_FLUSH_MIN_SPANS, 1000, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean(RUNTIME_CONTEXT_FIELD_INJECTION, true);
        this.propagationStylesToExtract = this.getPropagationStyleSetSettingFromEnvironmentOrDefault(PROPAGATION_STYLE_EXTRACT, ConfigDefaults.DEFAULT_PROPAGATION_STYLE_EXTRACT);
        this.propagationStylesToInject = this.getPropagationStyleSetSettingFromEnvironmentOrDefault(PROPAGATION_STYLE_INJECT, ConfigDefaults.DEFAULT_PROPAGATION_STYLE_INJECT);
        this.jmxFetchEnabled = configProvider.getBoolean(JMX_FETCH_ENABLED, true);
        this.jmxFetchConfigDir = configProvider.getString(JMX_FETCH_CONFIG_DIR);
        this.jmxFetchConfigs = configProvider.getList(JMX_FETCH_CONFIG);
        this.jmxFetchMetricsConfigs = configProvider.getList(JMX_FETCH_METRICS_CONFIGS);
        this.jmxFetchCheckPeriod = configProvider.getInteger(JMX_FETCH_CHECK_PERIOD);
        this.jmxFetchRefreshBeansPeriod = configProvider.getInteger(JMX_FETCH_REFRESH_BEANS_PERIOD);
        this.jmxFetchStatsdHost = configProvider.getString(JMX_FETCH_STATSD_HOST);
        this.jmxFetchStatsdPort = configProvider.getInteger(JMX_FETCH_STATSD_PORT, 8125, new String[0]);
        this.healthMetricsEnabled = configProvider.getBoolean(HEALTH_METRICS_ENABLED, false);
        this.healthMetricsStatsdHost = configProvider.getString(HEALTH_METRICS_STATSD_HOST);
        this.healthMetricsStatsdPort = configProvider.getInteger(HEALTH_METRICS_STATSD_PORT);
        this.perfMetricsEnabled = configProvider.getBoolean(PERF_METRICS_ENABLED, false);
        this.logsInjectionEnabled = configProvider.getBoolean(LOGS_INJECTION_ENABLED, false);
        this.logsMDCTagsInjectionEnabled = configProvider.getBoolean("logs.mdc.tags.injection", false);
        this.reportHostName = configProvider.getBoolean(TRACE_REPORT_HOSTNAME, false);
        this.traceAgentV05Enabled = configProvider.getBoolean("trace.agent.v0.5.enabled", true);
        this.traceAnnotations = configProvider.getString(TRACE_ANNOTATIONS, ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceMethods = configProvider.getString(TRACE_METHODS, ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]);
        this.traceExecutorsAll = configProvider.getBoolean(TRACE_EXECUTORS_ALL, false);
        this.traceExecutors = configProvider.getList(TRACE_EXECUTORS);
        this.traceAnalyticsEnabled = configProvider.getBoolean(TRACE_ANALYTICS_ENABLED, false);
        this.traceSamplingServiceRules = configProvider.getMergedMap(TRACE_SAMPLING_SERVICE_RULES);
        this.traceSamplingOperationRules = configProvider.getMergedMap(TRACE_SAMPLING_OPERATION_RULES);
        this.traceSampleRate = configProvider.getDouble(TRACE_SAMPLE_RATE);
        this.traceRateLimit = configProvider.getDouble(TRACE_RATE_LIMIT, 100.0);
        this.profilingEnabled = configProvider.getBoolean(PROFILING_ENABLED, false);
        this.profilingUrl = configProvider.getString(PROFILING_URL);
        if (tmpApiKey == null) {
            String oldProfilingApiKeyFile = configProvider.getString(PROFILING_API_KEY_FILE_OLD);
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName(PROFILING_API_KEY_OLD));
            if (oldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(oldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)oldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        if (tmpApiKey == null) {
            String veryOldProfilingApiKeyFile = configProvider.getString(PROFILING_API_KEY_FILE_VERY_OLD);
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName(PROFILING_API_KEY_VERY_OLD));
            if (veryOldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(veryOldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)veryOldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        this.profilingTags = configProvider.getMergedMap(PROFILING_TAGS);
        this.profilingStartDelay = configProvider.getInteger(PROFILING_START_DELAY, 10, new String[0]);
        this.profilingStartForceFirst = configProvider.getBoolean(PROFILING_START_FORCE_FIRST, false);
        this.profilingUploadPeriod = configProvider.getInteger(PROFILING_UPLOAD_PERIOD, 60, new String[0]);
        this.profilingTemplateOverrideFile = configProvider.getString(PROFILING_TEMPLATE_OVERRIDE_FILE);
        this.profilingUploadTimeout = configProvider.getInteger(PROFILING_UPLOAD_TIMEOUT, 30, new String[0]);
        this.profilingUploadCompression = configProvider.getString(PROFILING_UPLOAD_COMPRESSION, "on", new String[0]);
        this.profilingProxyHost = configProvider.getString(PROFILING_PROXY_HOST);
        this.profilingProxyPort = configProvider.getInteger(PROFILING_PROXY_PORT, 8080, new String[0]);
        this.profilingProxyUsername = configProvider.getString(PROFILING_PROXY_USERNAME);
        this.profilingProxyPassword = configProvider.getString(PROFILING_PROXY_PASSWORD);
        this.profilingExceptionSampleLimit = configProvider.getInteger(PROFILING_EXCEPTION_SAMPLE_LIMIT, 10000, new String[0]);
        this.profilingExceptionHistogramTopItems = configProvider.getInteger(PROFILING_EXCEPTION_HISTOGRAM_TOP_ITEMS, 50, new String[0]);
        this.profilingExceptionHistogramMaxCollectionSize = configProvider.getInteger(PROFILING_EXCEPTION_HISTOGRAM_MAX_COLLECTION_SIZE, 10000, new String[0]);
        this.kafkaClientPropagationEnabled = configProvider.getBoolean(KAFKA_CLIENT_PROPAGATION_ENABLED, true);
        this.kafkaClientBase64DecodingEnabled = configProvider.getBoolean(KAFKA_CLIENT_BASE64_DECODING_ENABLED, false);
        this.hystrixTagsEnabled = configProvider.getBoolean("hystrix.tags.enabled", false);
        this.servletPrincipalEnabled = configProvider.getBoolean("trace.servlet.principal.enabled", false);
        this.servletAsyncTimeoutError = configProvider.getBoolean("trace.servlet.async-timeout.error", true);
        this.debugEnabled = Config.isDebugMode();
        this.apiKey = tmpApiKey;
        log.debug("New instance: {}", (Object)this);
    }

    public Map<String, String> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, String> result = new HashMap<String, String>(runtimeTags);
        result.put("language", "jvm");
        if (this.reportHostName && null != (hostName = Config.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", hostName);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedProfilingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = Config.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.profilingTags.size() + runtimeTags.size() + 3);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.profilingTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        result.put("language", "jvm");
        return Collections.unmodifiableMap(result);
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            Float rate = this.configProvider.getFloat(alias + ".analytics.sample-rate");
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    private Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        Map<String, String> result = Config.newHashMap(2);
        result.put("runtime-id", this.runtimeId);
        return Collections.unmodifiableMap(result);
    }

    public String getFinalProfilingUrl() {
        if (this.profilingUrl != null) {
            return this.profilingUrl;
        }
        if (this.apiKey != null) {
            return String.format(PROFILING_REMOTE_URL_TEMPLATE, this.site);
        }
        return String.format(PROFILING_LOCAL_URL_TEMPLATE, this.agentHost, this.agentPort);
    }

    public boolean isIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "integration.", ".enabled", defaultEnabled);
    }

    public boolean isJmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "jmxfetch.", ".enabled", defaultEnabled);
    }

    public boolean isRuleEnabled(String name) {
        return this.configProvider.getBoolean("trace." + name + ".enabled", true) && this.configProvider.getBoolean("trace." + name.toLowerCase() + ".enabled", true);
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isJmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.isEnabled(Arrays.asList(integrationNames), "", ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.isEnabled(Arrays.asList(integrationNames), "", ".analytics.enabled", defaultEnabled);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv("dd.trace.debug".replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isTraceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    private boolean isEnabled(Iterable<String> integrationNames, String settingPrefix, String settingSuffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = this.configProvider.getBoolean(settingPrefix + name + settingSuffix, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    private Set<PropagationStyle> getPropagationStyleSetSettingFromEnvironmentOrDefault(String name, String defaultValue) {
        String value = this.configProvider.getString(name, defaultValue, new String[0]);
        Set<PropagationStyle> result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(value));
        if (result.isEmpty()) {
            result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(defaultValue));
        }
        return result;
    }

    @NonNull
    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(Config.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }

    @NonNull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    @NonNull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @NonNull
    private Map<String, String> getMapWithPropertiesDefinedByEnvironment(@NonNull Map<String, String> map, String ... propNames) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (propNames == null) {
            throw new NullPointerException("propNames is marked non-null but is null");
        }
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : propNames) {
            String val = this.configProvider.getString(propName);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @NonNull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : str.split(SPLIT_BY_SPACE_OR_COMMA_REGEX)) {
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return Collections.unmodifiableSet(result);
    }

    @NonNull
    private static Set<PropagationStyle> convertStringSetToPropagationStyleSet(Set<String> input) {
        LinkedHashSet<PropagationStyle> result = new LinkedHashSet<PropagationStyle>();
        for (String value : input) {
            try {
                result.add(PropagationStyle.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Cannot recognize config string value: {}, {}", (Object)value, PropagationStyle.class);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static String findConfigurationFile() {
        File configurationFile;
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName(CONFIGURATION_FILE));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName(CONFIGURATION_FILE));
        }
        if (null != configurationFilePath && !(configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")))).exists()) {
            return configurationFilePath;
        }
        return "no config file present";
    }

    private static String getHostName() {
        String possibleHostname = System.getProperty("os.name").startsWith("Windows") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(Config.INSTANCE.runtimeId, ConfigProvider.withPropertiesOverride(properties));
    }

    public String toString() {
        return "Config(apiKey=" + this.profilingApiKeyMasker() + ", profilingProxyPassword=" + this.profilingProxyPasswordMasker() + ", runtimeId=" + this.getRuntimeId() + ", site=" + this.getSite() + ", serviceName=" + this.getServiceName() + ", traceEnabled=" + this.isTraceEnabled() + ", integrationsEnabled=" + this.isIntegrationsEnabled() + ", writerType=" + this.getWriterType() + ", prioritizationType=" + this.getPrioritizationType() + ", agentConfiguredUsingDefault=" + this.isAgentConfiguredUsingDefault() + ", agentHost=" + this.getAgentHost() + ", agentPort=" + this.getAgentPort() + ", agentUnixDomainSocket=" + this.getAgentUnixDomainSocket() + ", agentTimeout=" + this.getAgentTimeout() + ", prioritySamplingEnabled=" + this.isPrioritySamplingEnabled() + ", prioritySamplingForce=" + this.getPrioritySamplingForce() + ", traceResolverEnabled=" + this.isTraceResolverEnabled() + ", serviceMapping=" + this.getServiceMapping() + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", excludedClasses=" + this.getExcludedClasses() + ", headerTags=" + this.getHeaderTags() + ", httpServerErrorStatuses=" + this.getHttpServerErrorStatuses() + ", httpClientErrorStatuses=" + this.getHttpClientErrorStatuses() + ", httpServerTagQueryString=" + this.isHttpServerTagQueryString() + ", httpClientTagQueryString=" + this.isHttpClientTagQueryString() + ", httpClientSplitByDomain=" + this.isHttpClientSplitByDomain() + ", dbClientSplitByInstance=" + this.isDbClientSplitByInstance() + ", splitByTags=" + this.getSplitByTags() + ", scopeDepthLimit=" + this.getScopeDepthLimit() + ", scopeStrictMode=" + this.isScopeStrictMode() + ", partialFlushMinSpans=" + this.getPartialFlushMinSpans() + ", runtimeContextFieldInjection=" + this.isRuntimeContextFieldInjection() + ", propagationStylesToExtract=" + this.getPropagationStylesToExtract() + ", propagationStylesToInject=" + this.getPropagationStylesToInject() + ", jmxFetchEnabled=" + this.isJmxFetchEnabled() + ", jmxFetchConfigDir=" + this.getJmxFetchConfigDir() + ", jmxFetchConfigs=" + this.getJmxFetchConfigs() + ", jmxFetchMetricsConfigs=" + this.getJmxFetchMetricsConfigs() + ", jmxFetchCheckPeriod=" + this.getJmxFetchCheckPeriod() + ", jmxFetchRefreshBeansPeriod=" + this.getJmxFetchRefreshBeansPeriod() + ", jmxFetchStatsdHost=" + this.getJmxFetchStatsdHost() + ", jmxFetchStatsdPort=" + this.getJmxFetchStatsdPort() + ", healthMetricsEnabled=" + this.isHealthMetricsEnabled() + ", healthMetricsStatsdHost=" + this.getHealthMetricsStatsdHost() + ", healthMetricsStatsdPort=" + this.getHealthMetricsStatsdPort() + ", perfMetricsEnabled=" + this.isPerfMetricsEnabled() + ", logsInjectionEnabled=" + this.isLogsInjectionEnabled() + ", logsMDCTagsInjectionEnabled=" + this.isLogsMDCTagsInjectionEnabled() + ", reportHostName=" + this.isReportHostName() + ", traceAnnotations=" + this.getTraceAnnotations() + ", traceMethods=" + this.getTraceMethods() + ", traceExecutorsAll=" + this.isTraceExecutorsAll() + ", traceExecutors=" + this.getTraceExecutors() + ", traceAnalyticsEnabled=" + this.isTraceAnalyticsEnabled() + ", traceSamplingServiceRules=" + this.getTraceSamplingServiceRules() + ", traceSamplingOperationRules=" + this.getTraceSamplingOperationRules() + ", traceSampleRate=" + this.getTraceSampleRate() + ", traceRateLimit=" + this.getTraceRateLimit() + ", profilingEnabled=" + this.isProfilingEnabled() + ", profilingUrl=" + this.profilingUrl + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.getProfilingStartDelay() + ", profilingStartForceFirst=" + this.isProfilingStartForceFirst() + ", profilingUploadPeriod=" + this.getProfilingUploadPeriod() + ", profilingTemplateOverrideFile=" + this.getProfilingTemplateOverrideFile() + ", profilingUploadTimeout=" + this.getProfilingUploadTimeout() + ", profilingUploadCompression=" + this.getProfilingUploadCompression() + ", profilingProxyHost=" + this.getProfilingProxyHost() + ", profilingProxyPort=" + this.getProfilingProxyPort() + ", profilingProxyUsername=" + this.getProfilingProxyUsername() + ", profilingExceptionSampleLimit=" + this.getProfilingExceptionSampleLimit() + ", profilingExceptionHistogramTopItems=" + this.getProfilingExceptionHistogramTopItems() + ", profilingExceptionHistogramMaxCollectionSize=" + this.getProfilingExceptionHistogramMaxCollectionSize() + ", kafkaClientPropagationEnabled=" + this.isKafkaClientPropagationEnabled() + ", kafkaClientBase64DecodingEnabled=" + this.isKafkaClientBase64DecodingEnabled() + ", hystrixTagsEnabled=" + this.isHystrixTagsEnabled() + ", servletPrincipalEnabled=" + this.isServletPrincipalEnabled() + ", servletAsyncTimeoutError=" + this.isServletAsyncTimeoutError() + ", traceAgentV05Enabled=" + this.isTraceAgentV05Enabled() + ", debugEnabled=" + this.isDebugEnabled() + ", configFile=" + this.getConfigFile() + ", idGenerationStrategy=" + this.getIdGenerationStrategy() + ", configProvider=" + this.configProvider + ")";
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSite() {
        return this.site;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public String getPrioritizationType() {
        return this.prioritizationType;
    }

    public boolean isAgentConfiguredUsingDefault() {
        return this.agentConfiguredUsingDefault;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public String getPrioritySamplingForce() {
        return this.prioritySamplingForce;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public BitSet getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public BitSet getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public int getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    @Deprecated
    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isPerfMetricsEnabled() {
        return this.perfMetricsEnabled;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isLogsMDCTagsInjectionEnabled() {
        return this.logsMDCTagsInjectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public Double getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public int getProfilingStartDelay() {
        return this.profilingStartDelay;
    }

    public boolean isProfilingStartForceFirst() {
        return this.profilingStartForceFirst;
    }

    public int getProfilingUploadPeriod() {
        return this.profilingUploadPeriod;
    }

    public String getProfilingTemplateOverrideFile() {
        return this.profilingTemplateOverrideFile;
    }

    public int getProfilingUploadTimeout() {
        return this.profilingUploadTimeout;
    }

    public String getProfilingUploadCompression() {
        return this.profilingUploadCompression;
    }

    public String getProfilingProxyHost() {
        return this.profilingProxyHost;
    }

    public int getProfilingProxyPort() {
        return this.profilingProxyPort;
    }

    public String getProfilingProxyUsername() {
        return this.profilingProxyUsername;
    }

    public String getProfilingProxyPassword() {
        return this.profilingProxyPassword;
    }

    public int getProfilingExceptionSampleLimit() {
        return this.profilingExceptionSampleLimit;
    }

    public int getProfilingExceptionHistogramTopItems() {
        return this.profilingExceptionHistogramTopItems;
    }

    public int getProfilingExceptionHistogramMaxCollectionSize() {
        return this.profilingExceptionHistogramMaxCollectionSize;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public boolean isKafkaClientBase64DecodingEnabled() {
        return this.kafkaClientBase64DecodingEnabled;
    }

    public boolean isHystrixTagsEnabled() {
        return this.hystrixTagsEnabled;
    }

    public boolean isServletPrincipalEnabled() {
        return this.servletPrincipalEnabled;
    }

    public boolean isServletAsyncTimeoutError() {
        return this.servletAsyncTimeoutError;
    }

    public boolean isTraceAgentV05Enabled() {
        return this.traceAgentV05Enabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.idGenerationStrategy;
    }
}

