/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Function;
import datadog.trace.api.TwoArgFunction;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;

public final class Functions {
    private static final Zero ZERO = new Zero();

    private Functions() {
    }

    public static <T> Zero<T> zero() {
        return ZERO;
    }

    public static final class ToString<T>
    implements Function<T, String> {
        @Override
        public String apply(T key) {
            return key.toString();
        }
    }

    public static final class LowerCase
    implements Function<String, String> {
        public static final LowerCase INSTANCE = new LowerCase();

        @Override
        public String apply(String key) {
            return key.toLowerCase();
        }
    }

    public static class SuffixJoin
    extends Join {
        public SuffixJoin(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            super(joiner, transformer);
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence specialisation) {
            return new Suffix(String.valueOf(this.joiner) + specialisation, this.transformer);
        }

        public static SuffixJoin of(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            return new SuffixJoin(joiner, transformer);
        }

        public static SuffixJoin of(CharSequence joiner) {
            return SuffixJoin.of(joiner, Functions.zero());
        }
    }

    public static class PrefixJoin
    extends Join {
        public PrefixJoin(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            super(joiner, transformer);
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence specialisation) {
            return new Prefix(String.valueOf(specialisation) + this.joiner, this.transformer);
        }

        public static PrefixJoin of(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            return new PrefixJoin(joiner, transformer);
        }

        public static PrefixJoin of(String joiner) {
            return PrefixJoin.of(joiner, Functions.zero());
        }
    }

    public static abstract class Join
    implements TwoArgFunction<CharSequence, CharSequence, CharSequence> {
        protected final CharSequence joiner;
        protected final Function<CharSequence, CharSequence> transformer;

        protected Join(CharSequence joiner, Function<CharSequence, CharSequence> transformer) {
            this.joiner = joiner;
            this.transformer = transformer;
        }

        @Override
        public CharSequence apply(CharSequence left, CharSequence right) {
            return UTF8BytesString.create(String.valueOf(left) + this.joiner + right);
        }
    }

    public static final class Prefix
    extends Concatenate
    implements Function<CharSequence, CharSequence> {
        private final CharSequence prefix;
        private final Function<CharSequence, CharSequence> transformer;
        public static final Prefix ZERO = new Prefix("", Functions.zero());

        public Prefix(CharSequence prefix, Function<CharSequence, CharSequence> transformer) {
            this.prefix = prefix;
            this.transformer = transformer;
        }

        public Prefix(CharSequence prefix) {
            this(prefix, Functions.zero());
        }

        @Override
        public CharSequence apply(CharSequence key) {
            return this.apply(this.prefix, this.transformer.apply(key));
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence prefix) {
            return new Prefix(prefix, this.transformer);
        }
    }

    public static final class Suffix
    extends Concatenate
    implements Function<CharSequence, CharSequence> {
        private final CharSequence suffix;
        private final Function<CharSequence, CharSequence> transformer;
        public static final Suffix ZERO = new Suffix("", Functions.zero());

        public Suffix(CharSequence suffix, Function<CharSequence, CharSequence> transformer) {
            this.suffix = suffix;
            this.transformer = transformer;
        }

        public Suffix(String suffix) {
            this(suffix, Functions.zero());
        }

        @Override
        public CharSequence apply(CharSequence key) {
            return this.apply(this.transformer.apply(key), this.suffix);
        }

        @Override
        public Function<CharSequence, CharSequence> curry(CharSequence suffix) {
            return new Suffix(suffix, this.transformer);
        }
    }

    public static abstract class Concatenate
    implements TwoArgFunction<CharSequence, CharSequence, CharSequence> {
        @Override
        public CharSequence apply(CharSequence left, CharSequence right) {
            return UTF8BytesString.create(String.valueOf(left) + right);
        }
    }

    public static final class Zero<T>
    implements Function<T, T> {
        @Override
        public T apply(T input) {
            return input;
        }
    }
}

