/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class RatelimitedLogger {
    private final Logger log;
    private final long delay;
    private final TimeSourceSupplier timeSource;
    private final AtomicLong previousErrorLogNanos = new AtomicLong();

    public RatelimitedLogger(Logger log, long delay) {
        this(log, delay, TimeSourceSupplier.DEFAULT);
    }

    RatelimitedLogger(Logger log, long delay, TimeSourceSupplier timeSource) {
        this.log = log;
        this.delay = delay;
        this.timeSource = timeSource;
    }

    public boolean warn(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.log.warn(format, arguments);
            return true;
        }
        if (this.log.isWarnEnabled()) {
            long previous = this.previousErrorLogNanos.get();
            long now = this.timeSource.get();
            if (now - previous >= this.delay && this.previousErrorLogNanos.compareAndSet(previous, now)) {
                this.log.warn(format + " (Will not log errors for 5 minutes)", arguments);
                return true;
            }
        }
        return false;
    }

    public static interface TimeSourceSupplier {
        public static final TimeSourceSupplier DEFAULT = new TimeSourceSupplier(){

            @Override
            public long get() {
                return System.nanoTime();
            }
        };

        public long get();
    }
}

