/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.RateSampler;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeterministicSampler
implements RateSampler {
    private static final Logger log = LoggerFactory.getLogger(DeterministicSampler.class);
    private static final long KNUTH_FACTOR = 1111111111111111111L;
    private final long cutoff;
    private final double rate;

    public DeterministicSampler(double rate) {
        this.rate = rate;
        this.cutoff = new BigDecimal(rate).multiply(new BigDecimal(CoreTracer.TRACE_ID_MAX)).toBigInteger().longValue() + Long.MIN_VALUE;
        log.debug("Initializing the RateSampler, sampleRate: {} %", (Object)(rate * 100.0));
    }

    @Override
    public boolean sample(DDSpan span) {
        long mod;
        boolean sampled = false;
        if (this.rate >= 1.0) {
            sampled = true;
        } else if (this.rate > 0.0 && (mod = span.getTraceId().toLong() * 1111111111111111111L) + Long.MIN_VALUE < this.cutoff) {
            sampled = true;
        }
        log.debug("{} - Span is sampled: {}", (Object)span, (Object)sampled);
        return sampled;
    }

    @Override
    public double getSampleRate() {
        return this.rate;
    }
}

