/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.jfr.DDScopeEvent;
import datadog.trace.core.jfr.DDScopeEventFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScopeManager
implements AgentScopeManager {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    final ThreadLocal<ScopeStack> tlsScopeStack = new ThreadLocal<ScopeStack>(){

        @Override
        protected final ScopeStack initialValue() {
            return new ScopeStack();
        }
    };
    private final DDScopeEventFactory scopeEventFactory;
    private final List<ScopeListener> scopeListeners;
    private final int depthLimit;
    private final StatsDClient statsDClient;
    private final boolean strictMode;

    public ContinuableScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory, StatsDClient statsDClient, boolean strictMode) {
        this(depthLimit, scopeEventFactory, statsDClient, strictMode, new CopyOnWriteArrayList<ScopeListener>());
    }

    private ContinuableScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory, StatsDClient statsDClient, boolean strictMode, List<ScopeListener> scopeListeners) {
        this.scopeEventFactory = scopeEventFactory;
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.statsDClient = statsDClient;
        this.strictMode = strictMode;
        this.scopeListeners = scopeListeners;
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope active = scopeStack.top();
        if (active != null && active.span.equals(span)) {
            active.incrementReferences();
            return active;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        return this.handleSpan(null, span, source);
    }

    private ContinuableScope handleSpan(Continuation continuation, AgentSpan span, ScopeSource source) {
        ContinuableScope scope = new ContinuableScope(this, continuation, span, source);
        this.scopeStack().push(scope);
        return scope;
    }

    @Override
    public TraceScope active() {
        return this.scopeStack().top();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().top();
        return active == null ? null : active.span();
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    protected ScopeStack scopeStack() {
        return this.tlsScopeStack.get();
    }

    private static final class Continuation
    implements AgentScope.Continuation {
        public WeakReference<AgentScope.Continuation> ref;
        private final ContinuableScopeManager scopeManager;
        private final AgentSpan spanUnderScope;
        private final ScopeSource source;
        private final AgentTrace trace;
        private final AtomicBoolean used = new AtomicBoolean(false);

        private Continuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, ScopeSource source) {
            this.scopeManager = scopeManager;
            this.spanUnderScope = spanUnderScope;
            this.source = source;
            this.trace = spanUnderScope.context().getTrace();
        }

        private Continuation register() {
            this.trace.registerContinuation(this);
            return this;
        }

        public AgentScope activate() {
            if (this.used.compareAndSet(false, true)) {
                ContinuableScope scope = this.scopeManager.handleSpan(this, this.spanUnderScope, this.source);
                log.debug("t_id={} -> activating continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
                return scope;
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
            return this.scopeManager.handleSpan(null, this.spanUnderScope, this.source);
        }

        public void cancel() {
            if (this.used.compareAndSet(false, true)) {
                this.trace.cancelContinuation(this);
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }

        private void cancelFromContinuedScopeClose() {
            this.trace.cancelContinuation(this);
        }

        @Override
        public boolean isRegistered() {
            return this.ref != null;
        }

        @Override
        public WeakReference<AgentScope.Continuation> register(ReferenceQueue referenceQueue) {
            this.ref = new WeakReference<Continuation>(this, referenceQueue);
            return this.ref;
        }

        @Override
        public void cancel(Set<WeakReference<AgentScope.Continuation>> weakReferences) {
            weakReferences.remove(this.ref);
            this.ref.clear();
            this.ref = null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
        }
    }

    static final class ScopeStack {
        private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();

        ScopeStack() {
        }

        final ContinuableScope top() {
            return this.stack.peek();
        }

        void cleanup() {
            ContinuableScope curScope = this.stack.peek();
            boolean changedTop = false;
            while (curScope != null) {
                if (curScope.alive()) {
                    if (!changedTop) break;
                    curScope.afterActivated();
                    break;
                }
                curScope.onProperClose();
                this.stack.poll();
                changedTop = true;
                curScope = this.stack.peek();
            }
        }

        final void push(ContinuableScope scope) {
            this.stack.push(scope);
            scope.afterActivated();
        }

        final boolean checkTop(ContinuableScope expectedScope) {
            return expectedScope.equals(this.stack.peek());
        }

        final int depth() {
            return this.stack.size();
        }

        final void clear() {
            this.stack.clear();
        }
    }

    private static final class ContinuableScope
    implements AgentScope {
        private final ContinuableScopeManager scopeManager;
        private final Continuation continuation;
        private final AtomicBoolean isAsyncPropagating = new AtomicBoolean(false);
        private final ScopeSource source;
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private final DDScopeEvent event;
        private final AgentSpan span;

        ContinuableScope(ContinuableScopeManager scopeManager, Continuation continuation, AgentSpan span, ScopeSource source) {
            this.span = span;
            this.event = scopeManager.scopeEventFactory.create(span.context());
            this.scopeManager = scopeManager;
            this.continuation = continuation;
            this.source = source;
        }

        @Override
        public void close() {
            boolean alive;
            ScopeStack scopeStack = this.scopeManager.scopeStack();
            boolean onTop = scopeStack.checkTop(this);
            if (!onTop) {
                if (log.isDebugEnabled()) {
                    log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top());
                }
                this.scopeManager.statsDClient.incrementCounter("scope.close.error", new String[0]);
                if (this.source == ScopeSource.MANUAL) {
                    this.scopeManager.statsDClient.incrementCounter("scope.user.close.error", new String[0]);
                    if (this.scopeManager.strictMode) {
                        throw new RuntimeException("Tried to close scope when not on top");
                    }
                }
            }
            if (alive = this.decrementReferences()) {
                return;
            }
            scopeStack.cleanup();
            if (null != this.continuation) {
                this.continuation.cancelFromContinuedScopeClose();
            }
        }

        final void onProperClose() {
            this.event.finish();
            for (ScopeListener listener : this.scopeManager.scopeListeners) {
                listener.afterScopeClosed();
            }
        }

        final void incrementReferences() {
            this.referenceCount.incrementAndGet();
        }

        final boolean decrementReferences() {
            return this.referenceCount.decrementAndGet() > 0;
        }

        final boolean alive() {
            return this.referenceCount.get() > 0;
        }

        public boolean isAsyncPropagating() {
            return this.isAsyncPropagating.get();
        }

        @Override
        public AgentSpan span() {
            return this.span;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.isAsyncPropagating.set(value);
        }

        public Continuation capture() {
            if (this.isAsyncPropagating()) {
                Continuation continuation = new Continuation(this.scopeManager, this.span, this.source);
                return continuation.register();
            }
            return null;
        }

        public String toString() {
            return super.toString() + "->" + this.span;
        }

        public void afterActivated() {
            for (ScopeListener listener : this.scopeManager.scopeListeners) {
                listener.afterScopeActivated();
            }
            this.event.start();
        }
    }
}

