/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.core.monitor.Recording;
import datadog.trace.core.monitor.Timer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class CPUTimer
extends Timer {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final StatsDClient statsd;
    private final String name;
    private final String[] tags = CPUTimer.getTags();
    private long start;
    private long cpuTime = 0L;

    CPUTimer(String name, StatsDClient statsd, long flushAfterNanos) {
        super(name, CPUTimer.getTags(), statsd, flushAfterNanos);
        this.name = name + ".cpu";
        this.statsd = statsd;
    }

    @Override
    public Recording start() {
        super.start();
        this.start = this.threadMXBean.getCurrentThreadCpuTime();
        return this;
    }

    @Override
    public void reset() {
        long cpuNanos = this.threadMXBean.getCurrentThreadCpuTime();
        this.cpuTime += cpuNanos - this.start;
        this.start = cpuNanos;
        super.reset();
    }

    @Override
    public void stop() {
        this.cpuTime += this.threadMXBean.getCurrentThreadCpuTime() - this.start;
        super.stop();
    }

    @Override
    public void flush() {
        super.flush();
        this.statsd.gauge(this.name, this.cpuTime, this.tags);
        this.cpuTime = 0L;
    }

    private static String[] getTags() {
        return new String[]{"thread:" + Thread.currentThread().getName()};
    }
}

