/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

import datadog.trace.core.util.SystemAccessProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;

final class JmxSystemAccessProvider
implements SystemAccessProvider {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    public static final JmxSystemAccessProvider INSTANCE = new JmxSystemAccessProvider();

    JmxSystemAccessProvider() {
    }

    @Override
    public long getThreadCpuTime() {
        return this.threadMXBean.getCurrentThreadCpuTime();
    }

    @Override
    public int getCurrentPid() {
        String name = this.runtimeMXBean.getName();
        if (name == null) {
            return 0;
        }
        int idx = name.indexOf(64);
        if (idx == -1) {
            return 0;
        }
        String pid = name.substring(0, idx);
        return Integer.parseInt(pid);
    }
}

