/*
 * Decompiled with CFR 0.152.
 */
package datadog.common.exec;

import datadog.common.exec.DaemonThreadFactory;
import java.lang.ref.WeakReference;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AgentTaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(AgentTaskScheduler.class);
    public static final AgentTaskScheduler INSTANCE = new AgentTaskScheduler(DaemonThreadFactory.TASK_SCHEDULER);
    private static final long SHUTDOWN_WAIT_MILLIS = 5000L;
    private final DelayQueue<PeriodicTask<?>> workQueue = new DelayQueue();
    private final ThreadFactory threadFactory;
    private volatile Thread worker;
    private volatile boolean shutdown;
    private static final AtomicInteger TASK_SEQUENCE_GENERATOR = new AtomicInteger();

    public AgentTaskScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public <T> void weakScheduleAtFixedRate(Task<T> task, T target, long initialDelay, long period, TimeUnit unit) {
        this.scheduleAtFixedRate(task, new WeakTarget<T>(target), initialDelay, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void scheduleAtFixedRate(Task<T> task, Target<T> target, long initialDelay, long period, TimeUnit unit) {
        if (target == null || target.get() == null) {
            return;
        }
        if (!this.shutdown && this.worker == null) {
            DelayQueue<PeriodicTask<?>> delayQueue = this.workQueue;
            synchronized (delayQueue) {
                if (!this.shutdown && this.worker == null) {
                    this.prepareWorkQueue();
                    try {
                        this.worker = this.threadFactory.newThread(new Worker());
                        Runtime.getRuntime().addShutdownHook(new Shutdown());
                        this.worker.start();
                    }
                    catch (IllegalStateException e) {
                        this.shutdown = true;
                    }
                }
            }
        }
        if (!this.shutdown) {
            this.workQueue.offer(new PeriodicTask<T>(task, target, initialDelay, period, unit));
        } else {
            log.warn("Agent task scheduler is shutdown. Will not run {}", (Object)AgentTaskScheduler.describeTask(task, target));
        }
    }

    private void prepareWorkQueue() {
        try {
            this.workQueue.poll(1L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    private static <T> String describeTask(Task<T> task, Target<T> target) {
        return "periodic task " + task.getClass().getSimpleName() + " with target " + target.get();
    }

    private static final class PeriodicTask<T>
    implements Delayed {
        private final Task<T> task;
        private final Target<T> target;
        private final int period;
        private final int taskSequence;
        private long time;

        public PeriodicTask(Task<T> task, Target<T> target, long initialDelay, long period, TimeUnit unit) {
            this.task = task;
            this.target = target;
            this.period = (int)unit.toNanos(period);
            this.taskSequence = TASK_SEQUENCE_GENERATOR.getAndIncrement();
            this.time = System.nanoTime() + unit.toNanos(initialDelay);
        }

        public void run() {
            T t = this.target.get();
            if (t != null) {
                this.task.run(t);
            }
        }

        public boolean reschedule() {
            if (this.target.get() != null) {
                this.time += (long)this.period;
                return true;
            }
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            long taskOrder;
            if (this == other) {
                return 0;
            }
            if (other instanceof PeriodicTask) {
                PeriodicTask otherTask = (PeriodicTask)other;
                taskOrder = this.time - otherTask.time;
                if (taskOrder == 0L) {
                    taskOrder = this.taskSequence - otherTask.taskSequence;
                }
            } else {
                taskOrder = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            }
            return taskOrder < 0L ? -1 : (taskOrder > 0L ? 1 : 0);
        }

        public String toString() {
            return AgentTaskScheduler.describeTask(this.task, this.target);
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (!AgentTaskScheduler.this.shutdown) {
                PeriodicTask work = null;
                try {
                    work = (PeriodicTask)AgentTaskScheduler.this.workQueue.take();
                    work.run();
                }
                catch (Throwable e) {
                    if (work == null) continue;
                    log.warn("Uncaught exception from {}", (Object)work, (Object)e);
                }
                finally {
                    if (work == null || !work.reschedule()) continue;
                    AgentTaskScheduler.this.workQueue.offer(work);
                }
            }
            AgentTaskScheduler.this.worker = null;
        }
    }

    private final class Shutdown
    extends Thread {
        private Shutdown() {
        }

        @Override
        public void run() {
            AgentTaskScheduler.this.shutdown = true;
            Thread t = AgentTaskScheduler.this.worker;
            if (t != null) {
                t.interrupt();
                t.join(5000L);
            }
        }
    }

    private static final class WeakTarget<T>
    extends WeakReference<T>
    implements Target<T> {
        public WeakTarget(T referent) {
            super(referent);
        }
    }

    public static interface Target<T> {
        public T get();
    }

    public static interface Task<T> {
        public void run(T var1);
    }
}

