/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.DeterministicSampler;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.sampling.SamplingRule;
import datadog.trace.core.DDSpan;
import datadog.trace.core.util.SimpleRateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedSampler
implements Sampler,
PrioritySampler {
    private static final Logger log = LoggerFactory.getLogger(RuleBasedSampler.class);
    private final List<SamplingRule> samplingRules;
    private final PrioritySampler fallbackSampler;
    private final SimpleRateLimiter rateLimiter;
    private final long rateLimit;
    public static final String SAMPLING_RULE_RATE = "_dd.rule_psr";
    public static final String SAMPLING_LIMIT_RATE = "_dd.limit_psr";

    public RuleBasedSampler(List<SamplingRule> samplingRules, long rateLimit, PrioritySampler fallbackSampler) {
        this.samplingRules = samplingRules;
        this.fallbackSampler = fallbackSampler;
        this.rateLimiter = new SimpleRateLimiter(rateLimit);
        this.rateLimit = rateLimit;
    }

    public static RuleBasedSampler build(Map<String, String> serviceRules, Map<String, String> operationRules, Double defaultRate, long rateLimit) {
        SamplingRule.PatternMatchSamplingRule samplingRule;
        ArrayList<SamplingRule> samplingRules = new ArrayList<SamplingRule>();
        if (serviceRules != null) {
            for (Map.Entry<String, String> entry : serviceRules.entrySet()) {
                try {
                    double rateForEntry = Double.parseDouble(entry.getValue());
                    samplingRule = new SamplingRule.ServiceSamplingRule(entry.getKey(), new DeterministicSampler(rateForEntry));
                    samplingRules.add(samplingRule);
                }
                catch (NumberFormatException e) {
                    log.error("Unable to parse rate for service: {}", entry, (Object)e);
                }
            }
        }
        if (operationRules != null) {
            for (Map.Entry<String, String> entry : operationRules.entrySet()) {
                try {
                    double rateForEntry = Double.parseDouble(entry.getValue());
                    samplingRule = new SamplingRule.OperationSamplingRule(entry.getKey(), new DeterministicSampler(rateForEntry));
                    samplingRules.add(samplingRule);
                }
                catch (NumberFormatException e) {
                    log.error("Unable to parse rate for operation: {}", entry, (Object)e);
                }
            }
        }
        if (defaultRate != null) {
            SamplingRule.AlwaysMatchesSamplingRule samplingRule2 = new SamplingRule.AlwaysMatchesSamplingRule(new DeterministicSampler(defaultRate));
            samplingRules.add(samplingRule2);
        }
        return new RuleBasedSampler(samplingRules, rateLimit, new RateByServiceSampler());
    }

    @Override
    public boolean sample(DDSpan span) {
        return true;
    }

    @Override
    public void setSamplingPriority(DDSpan span) {
        SamplingRule matchedRule = null;
        for (SamplingRule samplingRule : this.samplingRules) {
            if (!samplingRule.matches(span)) continue;
            matchedRule = samplingRule;
            break;
        }
        if (matchedRule == null) {
            this.fallbackSampler.setSamplingPriority(span);
        } else {
            boolean priorityWasSet;
            boolean usedRateLimiter = false;
            if (matchedRule.sample(span)) {
                usedRateLimiter = true;
                priorityWasSet = this.rateLimiter.tryAcquire() ? span.context().setSamplingPriority(1) : span.context().setSamplingPriority(0);
            } else {
                priorityWasSet = span.context().setSamplingPriority(0);
            }
            if (priorityWasSet) {
                span.context().setMetric(SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate());
                if (usedRateLimiter) {
                    span.context().setMetric(SAMPLING_LIMIT_RATE, this.rateLimit);
                }
            }
        }
    }
}

