/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.api.Config;
import datadog.trace.common.sampling.AllSampler;
import datadog.trace.common.sampling.ForcePrioritySampler;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.RuleBasedSampler;
import datadog.trace.core.DDSpan;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Sampler {
    public boolean sample(DDSpan var1);

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Sampler forConfig(Config config) {
            Sampler sampler;
            if (config != null) {
                Map<String, String> serviceRules = config.getTraceSamplingServiceRules();
                Map<String, String> operationRules = config.getTraceSamplingOperationRules();
                if (serviceRules != null && !serviceRules.isEmpty() || operationRules != null && !operationRules.isEmpty() || config.getTraceSampleRate() != null) {
                    try {
                        sampler = RuleBasedSampler.build(serviceRules, operationRules, config.getTraceSampleRate(), config.getTraceRateLimit());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid sampler configuration. Using AllSampler", (Throwable)e);
                        sampler = new AllSampler();
                    }
                } else if (config.isPrioritySamplingEnabled()) {
                    if ("keep".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_KEEP.");
                        sampler = new ForcePrioritySampler(1);
                    } else if ("drop".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_DROP.");
                        sampler = new ForcePrioritySampler(0);
                    } else {
                        sampler = new RateByServiceSampler();
                    }
                } else {
                    sampler = new AllSampler();
                }
            } else {
                sampler = new AllSampler();
            }
            return sampler;
        }

        public static Sampler forConfig(Properties config) {
            return Builder.forConfig(Config.get(config));
        }

        private Builder() {
        }
    }
}

