/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.common.writer.TraceStructureWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ListWriter
extends CopyOnWriteArrayList<List<DDSpan>>
implements Writer {
    private final TraceProcessor processor = new TraceProcessor();
    private final List<CountDownLatch> latches = new ArrayList<CountDownLatch>();
    private final AtomicInteger traceCount = new AtomicInteger();
    private final TraceStructureWriter structureWriter = new TraceStructureWriter();

    public List<DDSpan> firstTrace() {
        return (List)this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<DDSpan> trace) {
        this.incrementTraceCount();
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            trace = this.processor.onTraceComplete(trace);
            this.add(trace);
            for (CountDownLatch latch : this.latches) {
                if ((long)this.size() < latch.getCount()) continue;
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        }
        this.structureWriter.write(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTraces(int number) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(number);
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            if (this.size() >= number) {
                return;
            }
            this.latches.add(latch);
        }
        if (!latch.await(20L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Timeout waiting for " + number + " trace(s). ListWriter.size() == " + this.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReported(DDSpan span) throws InterruptedException, TimeoutException {
        CountDownLatch latch;
        do {
            latch = new CountDownLatch(this.size() + 1);
            List<CountDownLatch> list = this.latches;
            synchronized (list) {
                this.latches.add(latch);
            }
            if (!this.isReported(span)) continue;
            return;
        } while (latch.await(20L, TimeUnit.SECONDS));
        throw new TimeoutException("Timeout waiting for span to be reported: " + span);
    }

    private boolean isReported(DDSpan span) {
        for (List trace : this) {
            for (DDSpan aSpan : trace) {
                if (aSpan != span) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void incrementTraceCount() {
        this.traceCount.incrementAndGet();
    }

    @Override
    public void start() {
        this.close();
    }

    @Override
    public boolean flush() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.clear();
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            for (CountDownLatch latch : this.latches) {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
            this.latches.clear();
        }
    }

    @Override
    public String toString() {
        return "ListWriter { size=" + this.size() + " }";
    }
}

