/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.api.DDId;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TraceStructureWriter
implements Writer {
    private final PrintStream out;

    public TraceStructureWriter() {
        this("");
    }

    public TraceStructureWriter(String outputFile) {
        try {
            this.out = outputFile.isEmpty() || outputFile.equals(":") ? System.err : new PrintStream(new FileOutputStream(new File(outputFile.replace(":", ""))));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create trace structure writer from " + outputFile, e);
        }
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            this.out.println("[]");
        } else {
            DDId traceId = trace.get(0).getTraceId();
            DDId rootSpanId = trace.get(0).getSpanId();
            HashMap<DDId, Node> nodesById = new HashMap<DDId, Node>();
            for (DDSpan span : trace) {
                if (DDId.ZERO.equals((Object)span.getParentId())) {
                    rootSpanId = span.getSpanId();
                }
                nodesById.put(span.getSpanId(), new Node(span));
            }
            for (DDSpan span : trace) {
                if (!traceId.equals((Object)span.getTraceId())) {
                    this.out.println("ERROR: Trace " + traceId + " has broken trace link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getTraceId());
                    return;
                }
                if (rootSpanId.equals((Object)span.getSpanId())) continue;
                Node parent = (Node)nodesById.get(span.getParentId());
                if (null == parent) {
                    this.out.println("ERROR: Trace " + traceId + " has broken link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getParentId());
                    return;
                }
                parent.addChild((Node)nodesById.get(span.getSpanId()));
            }
            this.out.println(nodesById.get(rootSpanId));
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        this.out.flush();
        return true;
    }

    @Override
    public void close() {
        if (this.out != System.err) {
            this.out.close();
        }
    }

    @Override
    public void incrementTraceCount() {
    }

    private static final class Node {
        private final CharSequence operationName;
        private final List<Node> children = new ArrayList<Node>();

        private Node(DDSpan span) {
            this.operationName = span.getOperationName();
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.operationName);
            for (Node node : this.children) {
                sb.append(node);
            }
            return sb.append("]").toString();
        }
    }
}

