/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.DDSpanData;
import datadog.trace.core.StringTables;
import datadog.trace.core.TagsAndBaggageConsumer;
import datadog.trace.core.serialization.msgpack.ByteBufferConsumer;
import datadog.trace.core.serialization.msgpack.EncodingCachingStrategies;
import datadog.trace.core.serialization.msgpack.Mapper;
import datadog.trace.core.serialization.msgpack.Packer;
import datadog.trace.core.serialization.msgpack.Util;
import datadog.trace.core.serialization.msgpack.Writable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TraceMapperV0_5
implements TraceMapper {
    static final byte[] EMPTY = ByteBuffer.allocate(3).put((byte)-110).put((byte)-112).put((byte)-112).array();
    private static final DictionaryFull DICTIONARY_FULL = new DictionaryFull();
    private final ByteBuffer[] dictionary = new ByteBuffer[1];
    private final Packer dictionaryWriter;
    private final DictionaryMapper dictionaryMapper = new DictionaryMapper();
    private final Map<Object, Integer> encoding = new HashMap<Object, Integer>();
    private final MetaWriter metaWriter = new MetaWriter();

    public TraceMapperV0_5() {
        this(0x200000);
    }

    public TraceMapperV0_5(int bufferSize) {
        this.dictionaryWriter = new Packer(new ByteBufferConsumer(){

            @Override
            public void accept(int messageCount, ByteBuffer buffer) {
                ((TraceMapperV0_5)TraceMapperV0_5.this).dictionary[0] = buffer;
            }
        }, ByteBuffer.allocate(bufferSize), true);
        this.reset();
    }

    @Override
    public void map(List<? extends DDSpanData> trace, Writable writable) {
        writable.startArray(trace.size());
        for (DDSpanData dDSpanData : trace) {
            writable.startArray(12);
            this.writeDictionaryEncoded(writable, dDSpanData.getServiceName());
            this.writeDictionaryEncoded(writable, dDSpanData.getOperationName());
            this.writeDictionaryEncoded(writable, dDSpanData.getResourceName());
            writable.writeLong(dDSpanData.getTraceId().toLong());
            writable.writeLong(dDSpanData.getSpanId().toLong());
            writable.writeLong(dDSpanData.getParentId().toLong());
            writable.writeLong(dDSpanData.getStartTime());
            writable.writeLong(dDSpanData.getDurationNano());
            writable.writeInt(dDSpanData.getError());
            dDSpanData.processTagsAndBaggage(this.metaWriter.withWritable(writable));
            writable.startMap(dDSpanData.getMetrics().size());
            for (Map.Entry<String, Number> entry : dDSpanData.getMetrics().entrySet()) {
                this.writeDictionaryEncoded(writable, entry.getKey());
                writable.writeObject(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
            }
            this.writeDictionaryEncoded(writable, dDSpanData.getType());
        }
    }

    private void writeDictionaryEncoded(Writable writable, Object value) {
        Object target = null == value ? "" : value;
        Integer encoded = this.encoding.get(target);
        if (null == encoded) {
            if (!this.dictionaryWriter.format(target, this.dictionaryMapper)) {
                this.dictionaryWriter.flush();
                throw DICTIONARY_FULL;
            }
            int dictionaryCode = this.dictionaryWriter.messageCount() - 1;
            this.encoding.put(target, dictionaryCode);
            writable.writeInt(dictionaryCode);
        } else {
            writable.writeInt(encoded);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_5(this.getDictionary());
    }

    @Override
    public int messageBufferSize() {
        return 0x200000;
    }

    private ByteBuffer getDictionary() {
        if (this.dictionary[0] == null) {
            this.dictionaryWriter.flush();
        }
        return this.dictionary[0];
    }

    @Override
    public void reset() {
        this.dictionaryWriter.reset();
        this.dictionary[0] = null;
        this.encoding.clear();
    }

    @Override
    public String endpoint() {
        return "v0.5";
    }

    private final class MetaWriter
    extends TagsAndBaggageConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Map<String, Object> tags, Map<String, String> baggage) {
            int i;
            int size = tags.size();
            long overlaps = 0L;
            if (!baggage.isEmpty()) {
                i = 0;
                for (Map.Entry<String, String> entry : baggage.entrySet()) {
                    if (!tags.containsKey(entry.getKey())) {
                        ++size;
                    } else {
                        overlaps |= 1L << i;
                    }
                    ++i;
                }
            }
            this.writable.startMap(size);
            i = 0;
            for (Map.Entry<String, String> entry : baggage.entrySet()) {
                if ((overlaps & 1L << i) == 0L) {
                    TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                    TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
                }
                ++i;
            }
            for (Map.Entry<String, Object> entry : tags.entrySet()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
            }
        }
    }

    private static final class DictionaryFull
    extends BufferOverflowException {
        private DictionaryFull() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class PayloadV0_5
    extends Payload {
        private final ByteBuffer header = ByteBuffer.allocate(1).put(0, (byte)-110);
        private final ByteBuffer dictionary;

        private PayloadV0_5(ByteBuffer dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        int sizeInBytes() {
            return PayloadV0_5.sizeInBytes(this.header) + PayloadV0_5.sizeInBytes(this.dictionary) + PayloadV0_5.sizeInBytes(this.body);
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            PayloadV0_5.writeBufferToChannel(this.header, channel);
            PayloadV0_5.writeBufferToChannel(this.dictionary, channel);
            PayloadV0_5.writeBufferToChannel(this.body, channel);
        }
    }

    private static class DictionaryMapper
    implements Mapper<Object> {
        private final byte[] numberByteArray = Util.integerToStringBuffer();

        private DictionaryMapper() {
        }

        @Override
        public void map(Object data, Writable packer) {
            if (data instanceof UTF8BytesString) {
                packer.writeObject(data, EncodingCachingStrategies.NO_CACHING);
            } else if (data instanceof Long || data instanceof Integer) {
                Util.writeLongAsString(((Number)data).longValue(), packer, this.numberByteArray);
            } else {
                assert (null != data) : "enclosing mapper should not provide null values";
                String string = String.valueOf(data);
                byte[] utf8 = StringTables.getKeyBytesUTF8(string);
                if (null == utf8) {
                    packer.writeString(string, EncodingCachingStrategies.NO_CACHING);
                    return;
                }
                packer.writeUTF8(utf8);
            }
        }
    }
}

