/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.common.exec.DaemonThreadFactory;
import datadog.trace.core.PendingTrace;
import java.util.concurrent.TimeUnit;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscBlockingConsumerArrayQueue;

class PendingTraceBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;
    private final long FORCE_SEND_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private final long SEND_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    private final long SLEEP_TIME_MS = 100L;
    private final MpscBlockingConsumerArrayQueue<PendingTrace> queue = new MpscBlockingConsumerArrayQueue(4096);
    private final Thread worker = DaemonThreadFactory.TRACE_MONITOR.newThread(new Worker());
    private volatile boolean closed = false;

    PendingTraceBuffer() {
    }

    public void enqueue(PendingTrace pendingTrace) {
        if (!this.queue.offer((Object)pendingTrace)) {
            pendingTrace.write();
        }
    }

    public void start() {
        this.worker.start();
    }

    @Override
    public void close() {
        this.closed = true;
        this.worker.interrupt();
    }

    public void flush() {
        this.queue.drain((MessagePassingQueue.Consumer)WriteDrain.WRITE_DRAIN);
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (!PendingTraceBuffer.this.closed && !Thread.currentThread().isInterrupted()) {
                    PendingTrace pendingTrace = (PendingTrace)PendingTraceBuffer.this.queue.take();
                    long oldestFinishedTime = pendingTrace.oldestFinishedTime();
                    long finishTimestampMillis = TimeUnit.NANOSECONDS.toMillis(oldestFinishedTime);
                    if (finishTimestampMillis <= System.currentTimeMillis() - PendingTraceBuffer.this.FORCE_SEND_DELAY_MS) {
                        pendingTrace.write();
                        continue;
                    }
                    if (pendingTrace.lastReferencedNanosAgo(PendingTraceBuffer.this.SEND_DELAY_NS)) {
                        pendingTrace.write();
                        continue;
                    }
                    PendingTraceBuffer.this.enqueue(pendingTrace);
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class WriteDrain
    implements MessagePassingQueue.Consumer<PendingTrace> {
        private static final WriteDrain WRITE_DRAIN = new WriteDrain();

        private WriteDrain() {
        }

        public void accept(PendingTrace pendingTrace) {
            pendingTrace.write();
        }
    }
}

