/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.AppVeyorInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.AzurePipelinesInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.BitBucketInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.BuildkiteInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.CircleCIInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.GitLabInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.GithubActionsInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.JenkinsInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.NoopCIInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.TravisInfo;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class CIProviderInfo {
    public boolean isCI() {
        return true;
    }

    public abstract String getCiProviderName();

    public abstract String getCiPipelineId();

    public abstract String getCiPipelineName();

    public abstract String getCiPipelineNumber();

    public abstract String getCiPipelineUrl();

    public abstract String getCiJobUrl();

    public abstract String getCiWorkspacePath();

    public abstract String getGitRepositoryUrl();

    public abstract String getGitCommit();

    public abstract String getGitBranch();

    public abstract String getGitTag();

    public static CIProviderInfo selectCI() {
        if (System.getenv("JENKINS_URL") != null) {
            return new JenkinsInfo();
        }
        if (System.getenv("GITLAB_CI") != null) {
            return new GitLabInfo();
        }
        if (System.getenv("TRAVIS") != null) {
            return new TravisInfo();
        }
        if (System.getenv("CIRCLECI") != null) {
            return new CircleCIInfo();
        }
        if (System.getenv("APPVEYOR") != null) {
            return new AppVeyorInfo();
        }
        if (System.getenv("TF_BUILD") != null) {
            return new AzurePipelinesInfo();
        }
        if (System.getenv("BITBUCKET_COMMIT") != null) {
            return new BitBucketInfo();
        }
        if (System.getenv("GITHUB_ACTION") != null) {
            return new GithubActionsInfo();
        }
        if (System.getenv("BUILDKITE") != null) {
            return new BuildkiteInfo();
        }
        return new NoopCIInfo();
    }

    protected String expandTilde(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("~")) {
            return path;
        }
        if (!path.equals("~") && !path.startsWith("~/")) {
            return path;
        }
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    protected String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return null;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ref.replace("origin/", "");
        } else if (ref.startsWith("refs/heads")) {
            ref = ref.replace("refs/heads/", "");
        }
        if (ref.startsWith("tags")) {
            return ref.replace("tags/", "");
        }
        return ref;
    }

    protected String filterSensitiveInfo(String urlStr) {
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            URI url = new URI(urlStr);
            String userInfo = url.getRawUserInfo();
            return urlStr.replace(userInfo + "@", "");
        }
        catch (URISyntaxException ex) {
            return urlStr;
        }
    }
}

