/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.DDSpanData;
import datadog.trace.core.StringTables;
import datadog.trace.core.TagsAndBaggageConsumer;
import datadog.trace.core.serialization.msgpack.EncodingCachingStrategies;
import datadog.trace.core.serialization.msgpack.Util;
import datadog.trace.core.serialization.msgpack.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;

public final class TraceMapperV0_4
implements TraceMapper {
    static final byte[] EMPTY = ByteBuffer.allocate(1).put((byte)-112).array();
    private final MetaWriter metaWriter = new MetaWriter();

    @Override
    public void map(List<? extends DDSpanData> trace, Writable writable) {
        writable.startArray(trace.size());
        for (DDSpanData dDSpanData : trace) {
            writable.startMap(12);
            writable.writeUTF8(StringTables.SERVICE);
            writable.writeString(dDSpanData.getServiceName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.NAME);
            writable.writeObject(dDSpanData.getOperationName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.RESOURCE);
            writable.writeObject(dDSpanData.getResourceName(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.TRACE_ID);
            writable.writeLong(dDSpanData.getTraceId().toLong());
            writable.writeUTF8(StringTables.SPAN_ID);
            writable.writeLong(dDSpanData.getSpanId().toLong());
            writable.writeUTF8(StringTables.PARENT_ID);
            writable.writeLong(dDSpanData.getParentId().toLong());
            writable.writeUTF8(StringTables.START);
            writable.writeLong(dDSpanData.getStartTime());
            writable.writeUTF8(StringTables.DURATION);
            writable.writeLong(dDSpanData.getDurationNano());
            writable.writeUTF8(StringTables.TYPE);
            writable.writeString(dDSpanData.getType(), EncodingCachingStrategies.NO_CACHING);
            writable.writeUTF8(StringTables.ERROR);
            writable.writeInt(dDSpanData.getError());
            TraceMapperV0_4.writeMetrics(dDSpanData, writable);
            writable.writeUTF8(StringTables.META);
            dDSpanData.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
    }

    private static void writeMetrics(DDSpanData span, Writable writable) {
        writable.writeUTF8(StringTables.METRICS);
        Map<CharSequence, Number> metrics = span.getMetrics();
        int elementCount = metrics.size() + (span.isMeasured() ? 1 : 0);
        writable.startMap(elementCount);
        if (span.isMeasured()) {
            writable.writeUTF8(InstrumentationTags.DD_MEASURED);
            writable.writeInt(1);
        }
        for (Map.Entry<CharSequence, Number> metric : metrics.entrySet()) {
            writable.writeString(metric.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
            writable.writeObject(metric.getValue(), EncodingCachingStrategies.NO_CACHING);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return 0x500000;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "v0.4";
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        int sizeInBytes() {
            return PayloadV0_4.sizeInBytes(this.body);
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            PayloadV0_4.writeBufferToChannel(this.body, channel);
        }
    }

    private static final class MetaWriter
    extends TagsAndBaggageConsumer {
        private final byte[] numberByteArray = Util.integerToStringBuffer();
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Map<String, Object> tags, Map<String, String> baggage) {
            int i;
            int size = tags.size();
            long overlaps = 0L;
            if (!baggage.isEmpty()) {
                i = 0;
                for (Map.Entry<String, String> entry : baggage.entrySet()) {
                    if (!tags.containsKey(entry.getKey())) {
                        ++size;
                    } else {
                        overlaps |= 1L << i;
                    }
                    ++i;
                }
            }
            this.writable.startMap(size);
            i = 0;
            for (Map.Entry<String, String> entry : baggage.entrySet()) {
                if ((overlaps & 1L << i) == 0L) {
                    this.writable.writeString(entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                    this.writable.writeString(entry.getValue(), EncodingCachingStrategies.NO_CACHING);
                }
                ++i;
            }
            for (Map.Entry<String, Object> entry : tags.entrySet()) {
                this.writable.writeString(entry.getKey(), EncodingCachingStrategies.CONSTANT_KEYS);
                if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer) {
                    Util.writeLongAsString(((Number)entry.getValue()).longValue(), this.writable, this.numberByteArray);
                    continue;
                }
                if (entry.getValue() instanceof UTF8BytesString) {
                    this.writable.writeUTF8((UTF8BytesString)entry.getValue());
                    continue;
                }
                this.writable.writeString(String.valueOf(entry.getValue()), EncodingCachingStrategies.NO_CACHING);
            }
        }
    }
}

