/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

import datadog.trace.core.util.SystemAccessProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JmxSystemAccessProvider
implements SystemAccessProvider {
    private static final Logger log = LoggerFactory.getLogger(JmxSystemAccessProvider.class);
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final boolean cpuTimeSupported = this.threadMXBean.isCurrentThreadCpuTimeSupported();
    public static final JmxSystemAccessProvider INSTANCE = new JmxSystemAccessProvider();

    JmxSystemAccessProvider() {
    }

    @Override
    public long getThreadCpuTime() {
        return this.cpuTimeSupported ? this.threadMXBean.getCurrentThreadCpuTime() : Long.MIN_VALUE;
    }

    @Override
    public int getCurrentPid() {
        String name = this.runtimeMXBean.getName();
        if (name == null) {
            return 0;
        }
        int idx = name.indexOf(64);
        if (idx == -1) {
            return 0;
        }
        String pid = name.substring(0, idx);
        return Integer.parseInt(pid);
    }

    @Override
    public String executeDiagnosticCommand(String command, Object[] args, String[] sig) {
        ObjectName diagnosticCommandMBean = null;
        try {
            diagnosticCommandMBean = new ObjectName("com.sun.management:type=DiagnosticCommand");
        }
        catch (MalformedObjectNameException ex) {
            log.warn("Error during executeDiagnosticCommand: ", (Throwable)ex);
            return ex.getMessage();
        }
        try {
            Object result = ManagementFactory.getPlatformMBeanServer().invoke(diagnosticCommandMBean, command, args, sig);
            return result != null ? result.toString().trim() : null;
        }
        catch (Throwable ex) {
            log.warn("Error invoking diagnostic command: ", ex);
            return ex.getMessage();
        }
    }

    @Override
    public List<String> getVMArguments() {
        List<String> args = Collections.emptyList();
        try {
            args = this.runtimeMXBean.getInputArguments();
        }
        catch (Throwable ex) {
            log.warn("Error invoking runtimeMxBean.getInputArguments: ", ex);
        }
        return args;
    }
}

