/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;
import java.util.HashMap;

class JenkinsInfo
extends CIProviderInfo {
    public static final String JENKINS = "JENKINS_URL";
    public static final String JENKINS_PROVIDER_NAME = "jenkins";
    public static final String JENKINS_PIPELINE_ID = "BUILD_TAG";
    public static final String JENKINS_PIPELINE_NUMBER = "BUILD_NUMBER";
    public static final String JENKINS_PIPELINE_URL = "BUILD_URL";
    public static final String JENKINS_PIPELINE_NAME = "JOB_NAME";
    public static final String JENKINS_JOB_URL = "JOB_URL";
    public static final String JENKINS_WORKSPACE_PATH = "WORKSPACE";
    public static final String JENKINS_GIT_REPOSITORY_URL = "GIT_URL";
    public static final String JENKINS_GIT_COMMIT = "GIT_COMMIT";
    public static final String JENKINS_GIT_BRANCH = "GIT_BRANCH";
    private final String ciProviderName;
    private final String ciPipelineId = System.getenv("BUILD_TAG");
    private final String ciPipelineName;
    private final String ciPipelineNumber = System.getenv("BUILD_NUMBER");
    private final String ciPipelineUrl = System.getenv("BUILD_URL");
    private final String ciJobUrl = System.getenv("JOB_URL");
    private final String ciWorkspacePath = this.expandTilde(System.getenv("WORKSPACE"));
    private final String gitRepositoryUrl = this.filterSensitiveInfo(System.getenv("GIT_URL"));
    private final String gitCommit = System.getenv("GIT_COMMIT");
    private final String gitBranch = this.buildGitBranch();
    private final String gitTag = this.buildGitTag();

    JenkinsInfo() {
        this.ciProviderName = JENKINS_PROVIDER_NAME;
        this.ciPipelineName = this.buildCiPipelineName(this.gitBranch);
    }

    private String buildGitBranch() {
        String gitBranchOrTag = System.getenv(JENKINS_GIT_BRANCH);
        if (gitBranchOrTag != null && !gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitTag() {
        String gitBranchOrTag = System.getenv(JENKINS_GIT_BRANCH);
        if (gitBranchOrTag != null && gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildCiPipelineName(String branch) {
        String jobName = System.getenv(JENKINS_PIPELINE_NAME);
        return this.filterJenkinsJobName(jobName, branch);
    }

    @Override
    public String getCiProviderName() {
        return this.ciProviderName;
    }

    @Override
    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    @Override
    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    @Override
    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    @Override
    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    @Override
    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    @Override
    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public String getGitTag() {
        return this.gitTag;
    }

    private String filterJenkinsJobName(String jobName, String gitBranch) {
        if (jobName == null) {
            return null;
        }
        String jobNameNoBranch = gitBranch != null ? jobName.trim().replace("/" + gitBranch, "") : jobName;
        HashMap<String, String> configurations = new HashMap<String, String>();
        String[] jobNameParts = jobNameNoBranch.split("/");
        if (jobNameParts.length > 1 && jobNameParts[1].contains("=")) {
            String[] configsKeyValue;
            String configsStr = jobNameParts[1].toLowerCase().trim();
            for (String configKeyValue : configsKeyValue = configsStr.split(",")) {
                String[] keyValue = configKeyValue.trim().split("=");
                configurations.put(keyValue[0], keyValue[1]);
            }
        }
        if (configurations.isEmpty()) {
            return jobNameNoBranch;
        }
        return jobNameParts[0];
    }
}

