/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

public final class AggregateMetric {
    private int errorCount;
    private int hitCount;
    private long duration;

    public AggregateMetric addHits(int count) {
        this.hitCount += count;
        return this;
    }

    public AggregateMetric addErrors(int count) {
        this.errorCount += count;
        return this;
    }

    public AggregateMetric recordDurations(long errorMask, long ... durations) {
        for (long d : durations) {
            this.duration += d;
        }
        return this;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public long getDuration() {
        return this.duration;
    }

    public void clear() {
        this.errorCount = 0;
        this.hitCount = 0;
        this.duration = 0L;
    }
}

