/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.MetricKey;
import java.util.Arrays;

public final class Batch {
    public static final Batch NULL = new Batch(null);
    private volatile MetricKey key;
    private int count = 0;
    private long errorMask = 0L;
    private final long[] durations;

    Batch() {
        this(new long[64]);
    }

    private Batch(long[] durations) {
        this.durations = durations;
    }

    public MetricKey getKey() {
        return this.key;
    }

    public Batch withKey(MetricKey key) {
        this.key = key;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(boolean error, long durationNanos) {
        if (null != this.key && this.count < 64) {
            Batch batch = this;
            synchronized (batch) {
                if (null != this.key) {
                    return this.addExclusive(error, durationNanos);
                }
            }
        }
        return false;
    }

    boolean addExclusive(boolean error, long durationNanos) {
        if (this.count < 64) {
            if (error) {
                this.errorMask |= 1L << this.count;
            }
            this.durations[this.count++] = durationNanos;
            return true;
        }
        return false;
    }

    public synchronized void contributeTo(AggregateMetric aggregate) {
        this.key = null;
        aggregate.addErrors(Long.bitCount(this.errorMask)).addHits(this.count).recordDurations(this.errorMask, this.durations);
        this.clear();
    }

    private void clear() {
        this.count = 0;
        this.errorMask = 0L;
        Arrays.fill(this.durations, 0L);
    }
}

