/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.api.Config;
import datadog.trace.api.WellKnownTags;
import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.Batch;
import datadog.trace.common.metrics.EventListener;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.common.metrics.MetricsAggregator;
import datadog.trace.common.metrics.OkHttpSink;
import datadog.trace.common.metrics.SerializingMetricWriter;
import datadog.trace.common.metrics.Sink;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.util.LRUCache;
import datadog.trace.util.AgentThreadFactory;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscBlockingConsumerArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConflatingMetricsAggregator
implements MetricsAggregator,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(ConflatingMetricsAggregator.class);
    private static final Batch POISON_PILL = Batch.NULL;
    private final Queue<Batch> batchPool;
    private final ConcurrentHashMap<MetricKey, Batch> pending;
    private final Thread thread;
    private final BlockingQueue<Batch> inbox;
    private final Sink sink;
    private final Aggregator aggregator;
    private volatile boolean enabled = true;

    public ConflatingMetricsAggregator(Config config) {
        this(config.getWellKnownTags(), new OkHttpSink(config.getAgentUrl(), config.getAgentTimeout()), config.getTracerMetricsMaxAggregates(), config.getTracerMetricsMaxPending());
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Sink sink, int maxAggregates, int queueSize) {
        this(wellKnownTags, sink, maxAggregates, queueSize, 10L, TimeUnit.SECONDS);
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Sink sink, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this(sink, new SerializingMetricWriter(wellKnownTags, sink), maxAggregates, queueSize, reportingInterval, timeUnit);
    }

    ConflatingMetricsAggregator(Sink sink, MetricWriter metricWriter, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this.inbox = new MpscBlockingConsumerArrayQueue(queueSize);
        this.batchPool = new MpmcArrayQueue(maxAggregates);
        this.pending = new ConcurrentHashMap(maxAggregates * 4 / 3, 0.75f);
        this.sink = sink;
        this.aggregator = new Aggregator(metricWriter, this.batchPool, this.inbox, this.pending, maxAggregates, reportingInterval, timeUnit);
        this.thread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.METRICS_AGGREGATOR, this.aggregator);
    }

    @Override
    public void start() {
        this.sink.register(this);
        this.thread.start();
    }

    @Override
    public void publish(List<? extends CoreSpan<?>> trace) {
        if (this.enabled) {
            for (CoreSpan<?> span : trace) {
                if (!span.isMeasured()) continue;
                this.publish(span);
            }
        }
    }

    private void publish(CoreSpan<?> span) {
        boolean error = span.getError() > 0;
        long durationNanos = span.getDurationNano();
        MetricKey key = new MetricKey(span.getResourceName(), span.getServiceName(), span.getOperationName(), 0);
        Batch batch = this.pending.get(key);
        if (null != batch && batch.add(error, durationNanos)) {
            return;
        }
        batch = this.newBatch(key);
        batch.addExclusive(error, durationNanos);
        this.pending.put(key, batch);
        this.inbox.offer(batch);
    }

    private Batch newBatch(MetricKey key) {
        Batch batch = this.batchPool.poll();
        return (null == batch ? new Batch() : batch).withKey(key);
    }

    public void stop() {
        this.inbox.offer(POISON_PILL);
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        switch (eventType) {
            case DOWNGRADED: {
                log.debug("Disabling metric reporting because an agent downgrade was detected");
                this.disable();
                break;
            }
            case BAD_PAYLOAD: {
                log.debug("bad metrics payload sent to trace agent: {}", (Object)message);
                break;
            }
            case ERROR: {
                log.debug("trace agent errored receiving metrics payload: {}", (Object)message);
                break;
            }
        }
    }

    private void disable() {
        this.enabled = false;
        this.thread.interrupt();
        this.pending.clear();
        this.batchPool.clear();
        this.inbox.clear();
        this.aggregator.clearAggregates();
    }

    private static final class Aggregator
    implements Runnable {
        private final Queue<Batch> batchPool;
        private final BlockingQueue<Batch> inbox;
        private final LRUCache<MetricKey, AggregateMetric> aggregates;
        private final ConcurrentHashMap<MetricKey, Batch> pending;
        private final MetricWriter writer;
        private final long reportingIntervalNanos;
        private long wallClockTime = -1L;
        private long lastReportTime = -1L;

        private Aggregator(MetricWriter writer, Queue<Batch> batchPool, BlockingQueue<Batch> inbox, ConcurrentHashMap<MetricKey, Batch> pending, int maxAggregates, long reportingInterval, TimeUnit reportingIntervalTimeUnit) {
            this.writer = writer;
            this.batchPool = batchPool;
            this.inbox = inbox;
            this.aggregates = new LRUCache(maxAggregates, 0.75f, maxAggregates * 4 / 3);
            this.pending = pending;
            this.reportingIntervalNanos = reportingIntervalTimeUnit.toNanos(reportingInterval);
        }

        public void clearAggregates() {
            this.aggregates.clear();
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    Batch batch = this.inbox.take();
                    if (batch == POISON_PILL) {
                        this.report(this.wallClockTime());
                        return;
                    }
                    MetricKey key = batch.getKey();
                    this.pending.remove(key, batch);
                    AggregateMetric aggregate = (AggregateMetric)this.aggregates.get(key);
                    if (null == aggregate) {
                        aggregate = new AggregateMetric();
                        this.aggregates.put(key, aggregate);
                    }
                    batch.contributeTo(aggregate);
                    this.batchPool.offer(batch);
                    this.reportIfNecessary();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void reportIfNecessary() {
            long now;
            long delta;
            if (this.lastReportTime == -1L) {
                this.lastReportTime = System.nanoTime();
                this.wallClockTime = this.wallClockTime();
            } else if (!this.aggregates.isEmpty() && (delta = (now = System.nanoTime()) - this.lastReportTime) > this.reportingIntervalNanos) {
                this.report(this.wallClockTime + delta);
                this.lastReportTime = now;
                this.wallClockTime = this.wallClockTime();
            }
        }

        private void report(long when) {
            this.writer.startBucket(this.aggregates.size(), when, this.reportingIntervalNanos);
            for (Map.Entry aggregate : this.aggregates.entrySet()) {
                this.writer.add((MetricKey)aggregate.getKey(), (AggregateMetric)aggregate.getValue());
                ((AggregateMetric)aggregate.getValue()).clear();
            }
            this.writer.finishBucket();
        }

        private long wallClockTime() {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        }
    }
}

