/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.api.WellKnownTags;
import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.common.metrics.Sink;
import datadog.trace.core.serialization.ByteBufferConsumer;
import datadog.trace.core.serialization.WritableFormatter;
import datadog.trace.core.serialization.msgpack.MsgPackWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializingMetricWriter
implements MetricWriter {
    private static final Logger log = LoggerFactory.getLogger(SerializingMetricWriter.class);
    private static final byte[] HOSTNAME = "Hostname".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NAME = "Name".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ENV = "Env".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SERVICE = "Service".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] RESOURCE = "Resource".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] VERSION = "Version".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HITS = "Hits".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERRORS = "Errors".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] DURATION = "Duration".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] TOP_LEVEL = "TopLevel".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] START = "Start".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] STATS = "Stats".getBytes(StandardCharsets.US_ASCII);
    private final WellKnownTags wellKnownTags;
    private final WritableFormatter writer;

    public SerializingMetricWriter(WellKnownTags wellKnownTags, Sink sink) {
        this.wellKnownTags = wellKnownTags;
        this.writer = new MsgPackWriter((ByteBufferConsumer)sink, ByteBuffer.allocate(0x4000000), EnumSet.of(WritableFormatter.Feature.RESIZEABLE, WritableFormatter.Feature.SINGLE_MESSAGE));
    }

    @Override
    public void startBucket(int metricCount, long start, long duration) {
        this.writer.startMap(3);
        this.writer.writeUTF8(HOSTNAME);
        this.writer.writeUTF8(this.wellKnownTags.getHostname());
        this.writer.writeUTF8(ENV);
        this.writer.writeUTF8(this.wellKnownTags.getEnv());
        this.writer.writeUTF8(STATS);
        this.writer.startArray(1);
        this.writer.startMap(3);
        this.writer.writeUTF8(START);
        this.writer.writeLong(start);
        this.writer.writeUTF8(DURATION);
        this.writer.writeLong(duration);
        this.writer.writeUTF8(STATS);
        this.writer.startArray(metricCount);
    }

    @Override
    public void add(MetricKey key, AggregateMetric aggregate) {
        this.writer.startMap(9);
        this.writer.writeUTF8(NAME);
        this.writer.writeUTF8(key.getOperationName());
        this.writer.writeUTF8(ENV);
        this.writer.writeUTF8(this.wellKnownTags.getEnv());
        this.writer.writeUTF8(SERVICE);
        this.writer.writeUTF8(key.getService());
        this.writer.writeUTF8(RESOURCE);
        this.writer.writeUTF8(key.getResource());
        this.writer.writeUTF8(VERSION);
        this.writer.writeUTF8(this.wellKnownTags.getVersion());
        this.writer.writeUTF8(HITS);
        this.writer.writeFloat(aggregate.getHitCount());
        this.writer.writeUTF8(ERRORS);
        this.writer.writeFloat(aggregate.getErrorCount());
        this.writer.writeUTF8(DURATION);
        this.writer.writeDouble(aggregate.getDuration());
        this.writer.writeUTF8(TOP_LEVEL);
        this.writer.writeFloat(0.0f);
    }

    @Override
    public void finishBucket() {
        this.writer.flush();
    }
}

