/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor.rule;

import datadog.trace.api.Config;
import datadog.trace.core.ExclusiveSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.util.BitSet;

public class HttpStatusErrorRule
implements TraceProcessor.Rule {
    private final BitSet serverErrorStatuses = Config.get().getHttpServerErrorStatuses();
    private final BitSet clientErrorStatuses = Config.get().getHttpClientErrorStatuses();

    @Override
    public String[] aliases() {
        return new String[0];
    }

    @Override
    public void processSpan(ExclusiveSpan span) {
        CharSequence spanType;
        if (!span.isError() && null != (spanType = span.getType())) {
            switch (spanType.toString()) {
                case "web": {
                    span.setError(this.serverErrorStatuses.get(span.getHttpStatus()));
                    break;
                }
                case "http": {
                    span.setError(this.clientErrorStatuses.get(span.getHttpStatus()));
                    break;
                }
            }
        }
    }
}

