/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class CircleCIInfo
extends CIProviderInfo {
    public static final String CIRCLECI = "CIRCLECI";
    public static final String CIRCLECI_PROVIDER_NAME = "circleci";
    public static final String CIRCLECI_PIPELINE_ID = "CIRCLE_WORKFLOW_ID";
    public static final String CIRCLECI_PIPELINE_NAME = "CIRCLE_PROJECT_REPONAME";
    public static final String CIRCLECI_PIPELINE_NUMBER = "CIRCLE_BUILD_NUM";
    public static final String CIRCLECI_BUILD_URL = "CIRCLE_BUILD_URL";
    public static final String CIRCLECI_WORKSPACE_PATH = "CIRCLE_WORKING_DIRECTORY";
    public static final String CIRCLECI_GIT_REPOSITORY_URL = "CIRCLE_REPOSITORY_URL";
    public static final String CIRCLECI_GIT_COMMIT = "CIRCLE_SHA1";
    public static final String CIRCLECI_GIT_BRANCH = "CIRCLE_BRANCH";
    public static final String CIRCLECI_GIT_TAG = "CIRCLE_TAG";
    private final String ciProviderName;
    private final String ciPipelineId = System.getenv("CIRCLE_WORKFLOW_ID");
    private final String ciPipelineName = System.getenv("CIRCLE_PROJECT_REPONAME");
    private final String ciPipelineNumber = System.getenv("CIRCLE_BUILD_NUM");
    private final String ciPipelineUrl = System.getenv("CIRCLE_BUILD_URL");
    private final String ciJobUrl = System.getenv("CIRCLE_BUILD_URL");
    private final String ciWorkspacePath = this.expandTilde(System.getenv("CIRCLE_WORKING_DIRECTORY"));
    private final String gitRepositoryUrl = this.filterSensitiveInfo(System.getenv("CIRCLE_REPOSITORY_URL"));
    private final String gitCommit = System.getenv("CIRCLE_SHA1");
    private final String gitBranch;
    private final String gitTag = this.normalizeRef(System.getenv("CIRCLE_TAG"));

    CircleCIInfo() {
        this.ciProviderName = CIRCLECI_PROVIDER_NAME;
        this.gitBranch = this.buildGitBranch(this.gitTag);
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        return this.normalizeRef(System.getenv(CIRCLECI_GIT_BRANCH));
    }

    @Override
    public String getCiProviderName() {
        return this.ciProviderName;
    }

    @Override
    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    @Override
    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    @Override
    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    @Override
    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    @Override
    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    @Override
    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public String getGitTag() {
        return this.gitTag;
    }
}

