/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.Batch;
import datadog.trace.common.metrics.ConflatingMetricsAggregator;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.core.util.LRUCache;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

final class Aggregator
implements Runnable {
    private final Queue<Batch> batchPool;
    private final BlockingQueue<Batch> inbox;
    private final LRUCache<MetricKey, AggregateMetric> aggregates;
    private final ConcurrentHashMap<MetricKey, Batch> pending;
    private final MetricWriter writer;
    private final long reportingIntervalNanos;
    private long wallClockTime = -1L;
    private long lastReportTime = -1L;

    Aggregator(MetricWriter writer, Queue<Batch> batchPool, BlockingQueue<Batch> inbox, ConcurrentHashMap<MetricKey, Batch> pending, int maxAggregates, long reportingInterval, TimeUnit reportingIntervalTimeUnit) {
        this.writer = writer;
        this.batchPool = batchPool;
        this.inbox = inbox;
        this.aggregates = new LRUCache(maxAggregates, 0.75f, maxAggregates * 4 / 3);
        this.pending = pending;
        this.reportingIntervalNanos = reportingIntervalTimeUnit.toNanos(reportingInterval);
    }

    public void clearAggregates() {
        this.aggregates.clear();
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        while (!currentThread.isInterrupted()) {
            try {
                Batch batch = this.inbox.take();
                if (batch == ConflatingMetricsAggregator.POISON_PILL) {
                    this.report(this.wallClockTime());
                    return;
                }
                MetricKey key = batch.getKey();
                this.pending.remove(key, batch);
                AggregateMetric aggregate = (AggregateMetric)this.aggregates.get(key);
                if (null == aggregate) {
                    aggregate = new AggregateMetric();
                    this.aggregates.put(key, aggregate);
                }
                batch.contributeTo(aggregate);
                this.batchPool.offer(batch);
                this.reportIfNecessary();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void reportIfNecessary() {
        long now;
        long delta;
        if (this.lastReportTime == -1L) {
            this.lastReportTime = System.nanoTime();
            this.wallClockTime = this.wallClockTime();
        } else if (!this.aggregates.isEmpty() && (delta = (now = System.nanoTime()) - this.lastReportTime) > this.reportingIntervalNanos) {
            this.report(this.wallClockTime + delta);
            this.lastReportTime = now;
            this.wallClockTime = this.wallClockTime();
        }
    }

    private void report(long when) {
        this.writer.startBucket(this.aggregates.size(), when, this.reportingIntervalNanos);
        for (Map.Entry aggregate : this.aggregates.entrySet()) {
            this.writer.add((MetricKey)aggregate.getKey(), (AggregateMetric)aggregate.getValue());
            ((AggregateMetric)aggregate.getValue()).clear();
        }
        this.writer.finishBucket();
    }

    private long wallClockTime() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }
}

