/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.common.metrics.EventListener;
import datadog.trace.common.metrics.Sink;
import datadog.trace.core.http.OkHttpUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class OkHttpSink
implements Sink,
EventListener {
    private final OkHttpClient client;
    private final HttpUrl metricsUrl;
    private final List<EventListener> listeners;

    public OkHttpSink(String agentUrl, long timeoutMillis) {
        this(OkHttpUtils.buildHttpClient(HttpUrl.get((String)agentUrl), timeoutMillis), agentUrl, "v0.5/stats");
    }

    public OkHttpSink(OkHttpClient client, String agentUrl, String path) {
        this.client = client;
        this.metricsUrl = HttpUrl.get((String)agentUrl).resolve(path);
        this.listeners = new CopyOnWriteArrayList<EventListener>();
    }

    @Override
    public void accept(int messageCount, ByteBuffer buffer) {
        try (Response response = this.client.newCall(OkHttpUtils.prepareRequest(this.metricsUrl).put(OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(buffer))).build()).execute();){
            if (!response.isSuccessful()) {
                this.handleFailure(response);
            } else {
                this.onEvent(EventListener.EventType.OK, "");
            }
        }
        catch (IOException e) {
            this.onEvent(EventListener.EventType.ERROR, e.getMessage());
        }
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        for (EventListener listener : this.listeners) {
            listener.onEvent(eventType, message);
        }
    }

    @Override
    public void register(EventListener listener) {
        this.listeners.add(listener);
    }

    private void handleFailure(Response response) throws IOException {
        int code = response.code();
        if (code == 404) {
            this.onEvent(EventListener.EventType.DOWNGRADED, "could not find endpoint");
        } else if (code >= 400 && code < 500) {
            this.onEvent(EventListener.EventType.BAD_PAYLOAD, response.body().string());
        } else if (code >= 500) {
            this.onEvent(EventListener.EventType.ERROR, response.body().string());
        }
    }
}

