/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.RateSampler;
import datadog.trace.core.CoreSpan;
import java.util.regex.Pattern;

public abstract class SamplingRule<T extends CoreSpan<T>> {
    private final RateSampler<T> sampler;

    public SamplingRule(RateSampler<T> sampler) {
        this.sampler = sampler;
    }

    public abstract boolean matches(T var1);

    public boolean sample(T span) {
        return this.sampler.sample(span);
    }

    public RateSampler<T> getSampler() {
        return this.sampler;
    }

    public static class OperationSamplingRule<T extends CoreSpan<T>>
    extends PatternMatchSamplingRule<T> {
        public OperationSamplingRule(String regex, RateSampler<T> sampler) {
            super(regex, sampler);
        }

        @Override
        protected CharSequence getRelevantString(T span) {
            return span.getOperationName();
        }
    }

    public static class ServiceSamplingRule<T extends CoreSpan<T>>
    extends PatternMatchSamplingRule<T> {
        public ServiceSamplingRule(String regex, RateSampler<T> sampler) {
            super(regex, sampler);
        }

        @Override
        protected String getRelevantString(T span) {
            return span.getServiceName();
        }
    }

    public static abstract class PatternMatchSamplingRule<T extends CoreSpan<T>>
    extends SamplingRule<T> {
        private final Pattern pattern;

        public PatternMatchSamplingRule(String regex, RateSampler<T> sampler) {
            super(sampler);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(T span) {
            CharSequence relevantString = this.getRelevantString(span);
            return relevantString != null && this.pattern.matcher(relevantString).matches();
        }

        protected abstract CharSequence getRelevantString(T var1);
    }

    public static class AlwaysMatchesSamplingRule<T extends CoreSpan<T>>
    extends SamplingRule<T> {
        public AlwaysMatchesSamplingRule(RateSampler<T> sampler) {
            super(sampler);
        }

        @Override
        public boolean matches(T span) {
            return true;
        }
    }
}

