/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.api.IOLogger;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.common.writer.ddagent.TraceMapperV0_4;
import datadog.trace.common.writer.ddagent.TraceMapperV0_5;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.monitor.Counter;
import datadog.trace.core.monitor.Monitoring;
import datadog.trace.core.monitor.Recording;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi {
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final String DATADOG_CLIENT_COMPUTED_STATS = "Datadog-Client-Computed-Stats";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final String V3_ENDPOINT = "v0.3/traces";
    private static final String V4_ENDPOINT = "v0.4/traces";
    private static final String V5_ENDPOINT = "v0.5/traces";
    private final List<DDAgentResponseListener> responseListeners = new ArrayList<DDAgentResponseListener>();
    private final String[] endpoints;
    private long totalTraces = 0L;
    private long receivedTraces = 0L;
    private long sentTraces = 0L;
    private long failedTraces = 0L;
    private final Recording discoveryTimer;
    private final Recording sendPayloadTimer;
    private final Counter agentErrorCounter;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Double.class})}));
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private static final Map<String, RequestBody> ENDPOINT_SNIFF_REQUESTS;
    private final String agentUrl;
    private final long timeoutMillis;
    private final boolean metricsReportingEnabled;
    private final OkHttpClient httpClient;
    private HttpUrl tracesUrl;
    private String detectedVersion = null;
    private boolean agentRunning = false;
    private boolean agentDiscovered = false;
    private boolean usingUnixDomainSockets;
    private final IOLogger ioLogger = new IOLogger(log);

    public DDAgentApi(String agentUrl, String unixDomainSocketPath, long timeoutMillis, boolean enableV05Endpoint, boolean metricsReportingEnabled, Monitoring monitoring) {
        String[] stringArray;
        this.agentUrl = agentUrl;
        this.usingUnixDomainSockets = unixDomainSocketPath != null;
        this.timeoutMillis = timeoutMillis;
        this.metricsReportingEnabled = metricsReportingEnabled;
        this.httpClient = OkHttpUtils.buildHttpClient(HttpUrl.get((String)agentUrl), unixDomainSocketPath, timeoutMillis);
        if (enableV05Endpoint) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.endpoints = stringArray;
        this.discoveryTimer = monitoring.newTimer("trace.agent.discovery.time");
        this.sendPayloadTimer = monitoring.newTimer("trace.agent.send.time");
        this.agentErrorCounter = monitoring.newCounter("trace.agent.error.counter");
    }

    public DDAgentApi(String agentUrl, String unixDomainSocketPath, long timeoutMillis, Monitoring monitoring) {
        this(agentUrl, unixDomainSocketPath, timeoutMillis, true, false, monitoring);
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    TraceMapper selectTraceMapper() {
        String endpoint = this.detectEndpoint();
        if (null == endpoint) {
            return null;
        }
        if (V5_ENDPOINT.equals(endpoint)) {
            return new TraceMapperV0_5();
        }
        return new TraceMapperV0_4();
    }

    /*
     * Exception decompiling
     */
    Response sendSerializedTraces(Payload payload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void countAndLogSuccessfulSend(int traceCount, int sizeInBytes) {
        this.sentTraces += (long)traceCount;
        this.ioLogger.success(this.createSendLogMessage(traceCount, sizeInBytes, "Success"), new Object[0]);
    }

    private void countAndLogFailedSend(int traceCount, int sizeInBytes, okhttp3.Response response, IOException outer) {
        this.failedTraces += (long)traceCount;
        String agentError = DDAgentApi.getResponseBody(response);
        String sendErrorString = this.createSendLogMessage(traceCount, sizeInBytes, agentError.isEmpty() ? "Error" : agentError);
        this.ioLogger.error(sendErrorString, DDAgentApi.toLoggerResponse(response, agentError), outer);
    }

    private static IOLogger.Response toLoggerResponse(okhttp3.Response response, String body) {
        if (response == null) {
            return null;
        }
        return new IOLogger.Response(response.code(), response.message(), body);
    }

    private static String getResponseBody(okhttp3.Response response) {
        if (response != null) {
            try {
                return response.body().string().trim();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return "";
    }

    private String createSendLogMessage(int traceCount, int sizeInBytes, String prefix) {
        String sizeString = sizeInBytes > 1024 ? sizeInBytes / 1024 + "KB" : sizeInBytes + "B";
        return prefix + " while sending " + traceCount + " (size=" + sizeString + ") traces to the DD agent. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validateClient(String endpoint, OkHttpClient client, HttpUrl url) {
        RequestBody body = ENDPOINT_SNIFF_REQUESTS.get(endpoint);
        Request request = OkHttpUtils.prepareRequest(url).header(X_DATADOG_TRACE_COUNT, "0").put(body).build();
        try (okhttp3.Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                log.debug("connectivity to {} validated", (Object)url);
                boolean bl = true;
                return bl;
            }
            log.debug("connectivity to {} not validated, response code={}", (Object)url, (Object)response.code());
            return false;
        }
        catch (IOException e) {
            log.debug("failed to connect to datadog agent endpoint {}", (Object)endpoint, (Object)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String detectEndpoint() {
        block23: {
            if (!this.agentDiscovered) {
                try (Recording recording = this.discoveryTimer.start();){
                    HttpUrl baseUrl = HttpUrl.get((String)this.agentUrl);
                    this.agentRunning = this.isAgentRunning(baseUrl.host(), baseUrl.port(), this.timeoutMillis);
                    for (String candidate : this.endpoints) {
                        this.tracesUrl = baseUrl.newBuilder().addEncodedPathSegments(candidate).build();
                        if (DDAgentApi.validateClient(candidate, this.httpClient, HttpUrl.get((String)this.agentUrl).resolve(candidate))) {
                            this.agentDiscovered = true;
                            this.detectedVersion = candidate;
                            log.debug("connected to agent {}", (Object)candidate);
                            String string = candidate;
                            return string;
                        }
                        log.debug("API {} endpoints not available. Downgrading", (Object)candidate);
                    }
                    if (null == this.tracesUrl) {
                        log.error("no compatible agent detected");
                    }
                    break block23;
                }
                finally {
                    this.discoveryTimer.flush();
                }
            }
            log.warn("No connectivity to datadog agent");
        }
        if (null != this.detectedVersion) return this.detectedVersion;
        if (!log.isDebugEnabled()) return this.detectedVersion;
        log.debug("Tried all of {}, no connectivity to datadog agent", Arrays.asList(this.endpoints));
        return this.detectedVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAgentRunning(String host, int port, long timeoutMillis) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), (int)timeoutMillis);
            log.debug("Agent connectivity ({}:{})", (Object)host, (Object)port);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            log.debug("No agent connectivity ({}:{})", (Object)host, (Object)port);
            return false;
        }
    }

    static {
        HashMap<String, RequestBody> requests = new HashMap<String, RequestBody>();
        requests.put(V5_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_5.EMPTY));
        requests.put(V4_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_4.EMPTY));
        requests.put(V3_ENDPOINT, RequestBody.create((MediaType)MSGPACK, (byte[])TraceMapperV0_4.EMPTY));
        ENDPOINT_SNIFF_REQUESTS = Collections.unmodifiableMap(requests);
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;
        private final String response;

        public static Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static Response success(int status, String response) {
            return new Response(true, status, null, response);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception, null);
        }

        public static Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception, null);
        }

        private Response(boolean success, Integer status, Throwable exception, String response) {
            this.success = success;
            this.status = status;
            this.exception = exception;
            this.response = response;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }

        public final String response() {
            return this.response;
        }
    }
}

