/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.ExclusiveSpan;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.TagsAndBaggageConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements AgentSpan.Context {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    public static final String PRIORITY_SAMPLING_KEY = "_sampling_priority_v1";
    public static final String SAMPLE_RATE_KEY = "_sample_rate";
    public static final String ORIGIN_KEY = "_dd.origin";
    private static final Map<CharSequence, Number> EMPTY_METRICS = Collections.emptyMap();
    private final CoreTracer tracer;
    private final PendingTrace trace;
    private final Map<String, String> baggageItems;
    private final DDId traceId;
    private final DDId spanId;
    private final DDId parentId;
    private final Map<String, Object> unsafeTags;
    private volatile String serviceName;
    private volatile CharSequence resourceName;
    private volatile CharSequence operationName;
    private volatile CharSequence spanType;
    private volatile boolean errorFlag;
    private volatile boolean measuredFlag;
    private boolean samplingPriorityLocked = false;
    private final String origin;
    private final AtomicReference<Map<CharSequence, Number>> metrics = new AtomicReference();
    private final Map<String, String> serviceNameMappings;
    private final ExclusiveSpan exclusiveSpan;

    public DDSpanContext(DDId traceId, DDId spanId, DDId parentId, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, String origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, PendingTrace trace, CoreTracer tracer, Map<String, String> serviceNameMappings) {
        assert (tracer != null);
        assert (trace != null);
        this.tracer = tracer;
        this.trace = trace;
        assert (traceId != null);
        assert (spanId != null);
        assert (parentId != null);
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.baggageItems = baggageItems == null ? new ConcurrentHashMap<String, String>(0) : new ConcurrentHashMap<String, String>(baggageItems);
        int capacity = (tagsSize <= 0 ? 3 : tagsSize + 3) * 4 / 3;
        this.unsafeTags = new HashMap<String, Object>(capacity);
        this.serviceNameMappings = serviceNameMappings;
        this.setServiceName(serviceName);
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        this.origin = origin;
        if (samplingPriority != Integer.MIN_VALUE) {
            this.setSamplingPriority(samplingPriority);
        }
        if (origin != null) {
            this.unsafeTags.put(ORIGIN_KEY, origin);
        }
        Thread current = Thread.currentThread();
        this.unsafeTags.put("thread.name", current.getName());
        this.unsafeTags.put("thread.id", current.getId());
        this.exclusiveSpan = new ExclusiveSpan(this);
    }

    @Override
    public DDId getTraceId() {
        return this.traceId;
    }

    public DDId getParentId() {
        return this.parentId;
    }

    @Override
    public DDId getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        String mappedServiceName = this.serviceNameMappings.get(serviceName);
        this.serviceName = mappedServiceName == null ? serviceName : mappedServiceName;
    }

    public CharSequence getResourceName() {
        return this.isResourceNameSet() ? this.resourceName : this.operationName;
    }

    public boolean isResourceNameSet() {
        return this.resourceName != null && this.resourceName.length() != 0;
    }

    public boolean hasResourceName() {
        return this.isResourceNameSet() || this.getTag("resource.name") != null;
    }

    public void setResourceName(CharSequence resourceName) {
        this.resourceName = resourceName;
    }

    public CharSequence getOperationName() {
        return this.operationName;
    }

    public void setOperationName(CharSequence operationName) {
        this.operationName = operationName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        if (errorFlag != this.errorFlag) {
            this.errorFlag = errorFlag;
        }
    }

    public boolean isMeasured() {
        return this.measuredFlag;
    }

    public void setMeasured(boolean measured) {
        if (measured != this.measuredFlag) {
            this.measuredFlag = measured;
        }
    }

    public CharSequence getSpanType() {
        return this.spanType;
    }

    public void setSpanType(CharSequence spanType) {
        this.spanType = spanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSamplingPriority(int newPriority) {
        DDSpan rootSpan;
        if (newPriority == Integer.MIN_VALUE) {
            log.debug("{}: Refusing to set samplingPriority to UNSET", (Object)this);
            return false;
        }
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            return rootSpan.context().setSamplingPriority(newPriority);
        }
        DDSpanContext dDSpanContext = this;
        synchronized (dDSpanContext) {
            if (this.samplingPriorityLocked) {
                log.debug("samplingPriority locked at {}. Refusing to set to {}", (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY), (Object)newPriority);
                return false;
            }
            this.setMetric(PRIORITY_SAMPLING_KEY, newPriority);
            log.debug("Set sampling priority to {}", (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY));
            return true;
        }
    }

    public int getSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().getSamplingPriority();
        }
        Number val = this.getMetrics().get(PRIORITY_SAMPLING_KEY);
        return null == val ? Integer.MIN_VALUE : val.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().lockSamplingPriority();
        }
        DDSpanContext dDSpanContext = this;
        synchronized (dDSpanContext) {
            if (this.getMetrics().get(PRIORITY_SAMPLING_KEY) == null) {
                log.debug("{} : refusing to lock unset samplingPriority", (Object)this);
            } else if (!this.samplingPriorityLocked) {
                this.samplingPriorityLocked = true;
                log.debug("{} : locked samplingPriority to {}", (Object)this, (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY));
            }
            return this.samplingPriorityLocked;
        }
    }

    public String getOrigin() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan) {
            return rootSpan.context().origin;
        }
        return this.origin;
    }

    public void setBaggageItem(String key, String value) {
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @Override
    public PendingTrace getTrace() {
        return this.trace;
    }

    @Deprecated
    public CoreTracer getTracer() {
        return this.tracer;
    }

    public Map<CharSequence, Number> getMetrics() {
        Map<CharSequence, Number> metrics = this.metrics.get();
        return metrics == null ? EMPTY_METRICS : metrics;
    }

    public void setMetric(CharSequence key, Number value) {
        if (this.metrics.get() == null) {
            this.metrics.compareAndSet(null, new ConcurrentHashMap());
        }
        if (value instanceof Float) {
            this.metrics.get().put(key, value.doubleValue());
        } else {
            this.metrics.get().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTag(String tag, Object value) {
        if (null == value || "".equals(value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeTags.remove(tag);
            }
        }
        if (!this.tracer.getTagInterceptor().interceptTag(this.exclusiveSpan, tag, value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeSetTag(tag, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAllTags(Map<String, ? extends Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Map<String, Object> map2 = this.unsafeTags;
        synchronized (map2) {
            for (Map.Entry<String, ? extends Object> tag : map.entrySet()) {
                if (this.tracer.getTagInterceptor().interceptTag(this.exclusiveSpan, tag.getKey(), tag.getValue())) continue;
                this.unsafeSetTag(tag.getKey(), tag.getValue());
            }
        }
    }

    void unsafeSetTag(String tag, Object value) {
        this.unsafeTags.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getTag(String key) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            return this.unsafeGetTag(key);
        }
    }

    Object unsafeGetTag(String tag) {
        return this.unsafeTags.get(tag);
    }

    Object unsafeGetAndRemoveTag(String tag) {
        return this.unsafeTags.remove(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            return Collections.unmodifiableMap(new HashMap<String, Object>(this.unsafeTags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTagsAndBaggage(TagsAndBaggageConsumer consumer) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            consumer.accept(this.unsafeTags, this.baggageItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExclusiveSpan(ExclusiveSpan.Consumer consumer) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            consumer.accept(this.exclusiveSpan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s = new StringBuilder().append("DDSpan [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append(" ] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName()).append(" metrics=").append(new TreeMap<CharSequence, Number>(this.getMetrics()));
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.unsafeTags));
        }
        return s.toString();
    }
}

