/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.api.IntFunction;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.core.DDSpan;
import java.util.List;

public class HealthMetrics {
    private static final IntFunction<String[]> STATUS_TAGS = new IntFunction<String[]>(){

        @Override
        public String[] apply(int httpStatus) {
            return new String[]{"status:" + httpStatus};
        }
    };
    private static final String[] NO_TAGS = new String[0];
    private final RadixTreeCache<String[]> statusTagsCache = new RadixTreeCache<String[]>(16, 32, STATUS_TAGS, 200, 400);
    private static final String[] USER_DROP_TAG = new String[]{"priority:user_drop"};
    private static final String[] USER_KEEP_TAG = new String[]{"priority:user_keep"};
    private static final String[] SAMPLER_DROP_TAG = new String[]{"priority:sampler_drop"};
    private static final String[] SAMPLER_KEEP_TAG = new String[]{"priority:sampler_keep"};
    private static final String[] UNSET_TAG = new String[]{"priority:unset"};
    private final StatsDClient statsd;

    private static String[] samplingPriorityTag(int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                return USER_DROP_TAG;
            }
            case 2: {
                return USER_KEEP_TAG;
            }
            case 0: {
                return SAMPLER_DROP_TAG;
            }
            case 1: {
                return SAMPLER_KEEP_TAG;
            }
        }
        return UNSET_TAG;
    }

    public HealthMetrics(StatsDClient statsd) {
        this.statsd = statsd;
    }

    public void onStart(int queueCapacity) {
        this.statsd.recordGaugeValue("queue.max_length", (long)queueCapacity, NO_TAGS);
    }

    public void onShutdown(boolean flushSuccess) {
    }

    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        this.statsd.incrementCounter("queue.enqueued.traces", HealthMetrics.samplingPriorityTag(samplingPriority));
        this.statsd.count("queue.enqueued.spans", (long)trace.size(), NO_TAGS);
    }

    public void onFailedPublish(int samplingPriority) {
        this.statsd.incrementCounter("queue.dropped.traces", HealthMetrics.samplingPriorityTag(samplingPriority));
    }

    public void onScheduleFlush(boolean previousIncomplete) {
    }

    public void onFlush(boolean early) {
    }

    public void onSerialize(int serializedSizeInBytes) {
        this.statsd.count("queue.enqueued.bytes", (long)serializedSizeInBytes, NO_TAGS);
    }

    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
    }

    public void onSend(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    public void onFailedSend(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    private void onSendAttempt(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.statsd.incrementCounter("api.requests.total", NO_TAGS);
        this.statsd.count("flush.traces.total", (long)traceCount, NO_TAGS);
        this.statsd.count("flush.bytes.total", (long)sizeInBytes, NO_TAGS);
        if (response.exception() != null) {
            this.statsd.incrementCounter("api.errors.total", NO_TAGS);
        }
        if (response.status() != null) {
            this.statsd.incrementCounter("api.responses.total", this.statusTagsCache.get(response.status()));
        }
    }
}

