/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor;

import datadog.trace.api.Config;
import datadog.trace.core.DDSpan;
import datadog.trace.core.ExclusiveSpan;
import datadog.trace.core.processor.rule.URLAsResourceNameRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceProcessor {
    private static final Logger log = LoggerFactory.getLogger(TraceProcessor.class);
    final Rule[] DEFAULT_RULES = new Rule[]{new URLAsResourceNameRule()};
    private final List<Rule> rules = new ArrayList<Rule>(this.DEFAULT_RULES.length);

    public TraceProcessor() {
        for (Rule rule : this.DEFAULT_RULES) {
            if (!TraceProcessor.isEnabled(rule)) continue;
            this.rules.add(rule);
        }
    }

    private static boolean isEnabled(Rule rule) {
        boolean enabled = Config.get().isRuleEnabled(rule.getClass().getSimpleName());
        for (String alias : rule.aliases()) {
            enabled &= Config.get().isRuleEnabled(alias);
        }
        if (!enabled) {
            log.debug("{} disabled", (Object)rule.getClass().getSimpleName());
        }
        return enabled;
    }

    public List<DDSpan> onTraceComplete(List<DDSpan> trace) {
        for (DDSpan span : trace) {
            this.applyRules(span);
        }
        return trace;
    }

    private void applyRules(DDSpan span) {
        if (this.rules.size() > 0) {
            span.context().processExclusiveSpan(new ExclusiveSpan.Consumer(){

                @Override
                public void accept(ExclusiveSpan span) {
                    for (Rule rule : TraceProcessor.this.rules) {
                        rule.processSpan(span);
                    }
                }
            });
        }
    }

    public static interface Rule {
        public String[] aliases();

        public void processSpan(ExclusiveSpan var1);
    }
}

