/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.serialization.ByteBufferConsumer;
import datadog.trace.core.serialization.Codec;
import datadog.trace.core.serialization.EncodingCache;
import datadog.trace.core.serialization.Mapper;
import datadog.trace.core.serialization.MessageFormatter;
import datadog.trace.core.serialization.ValueWriter;
import datadog.trace.core.serialization.Writable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;

public abstract class WritableFormatter
implements Writable,
MessageFormatter {
    protected final Codec codec;
    private final ByteBufferConsumer sink;
    private final int maxArrayHeaderSize;
    private final boolean resizeable;
    private final boolean manualReset;
    private final boolean writeArray;
    protected ByteBuffer buffer;
    protected int messageCount = 0;

    protected WritableFormatter(Codec codec, ByteBufferConsumer sink, ByteBuffer buffer, EnumSet<Feature> features, int maxArrayHeaderSize) {
        this.codec = codec;
        this.sink = sink;
        this.buffer = buffer;
        this.manualReset = features.contains((Object)Feature.MANUAL_RESET);
        this.resizeable = features.contains((Object)Feature.RESIZEABLE);
        this.writeArray = !features.contains((Object)Feature.SINGLE_MESSAGE);
        this.maxArrayHeaderSize = maxArrayHeaderSize;
        this.initBuffer();
    }

    protected void initBuffer() {
        this.buffer.mark();
    }

    public abstract void reset();

    @Override
    public <T> boolean format(T message, Mapper<T> mapper) {
        try {
            mapper.map(message, this);
            this.mark();
            return true;
        }
        catch (BufferOverflowException e) {
            this.buffer.reset();
            if (this.resizeable) {
                this.buffer = WritableFormatter.resize(this.buffer);
                return this.format(message, mapper);
            }
            if (!this.manualReset) {
                if (this.buffer.position() == this.maxArrayHeaderSize) {
                    throw e;
                }
                this.flush();
                return this.format(message, mapper);
            }
            return false;
        }
    }

    public int messageCount() {
        return this.messageCount;
    }

    protected void mark() {
        this.buffer.mark();
        ++this.messageCount;
    }

    @Override
    public void flush() {
        this.buffer.flip();
        this.writeHeader(this.writeArray);
        this.sink.accept(this.messageCount, this.buffer.slice());
        if (!this.manualReset) {
            this.reset();
        }
    }

    protected abstract void writeHeader(boolean var1);

    public void writeMap(Map<? extends CharSequence, ? extends Object> map, EncodingCache encodingCache) {
        this.startMap(map.size());
        for (Map.Entry<? extends CharSequence, ? extends Object> entry : map.entrySet()) {
            this.writeString(entry.getKey(), encodingCache);
            this.writeObject(entry.getValue(), encodingCache);
        }
    }

    @Override
    public void writeObject(Object value, EncodingCache encodingCache) {
        if (value instanceof UTF8BytesString) {
            this.writeUTF8((UTF8BytesString)value);
        } else if (null == value) {
            this.writeNull();
        } else {
            ValueWriter writer = (ValueWriter)this.codec.get(value.getClass());
            writer.write(value, this, encodingCache);
        }
    }

    private static ByteBuffer resize(ByteBuffer oldBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(oldBuffer.capacity() * 2);
        oldBuffer.flip();
        newBuffer.put(oldBuffer);
        return newBuffer;
    }

    public static enum Feature {
        MANUAL_RESET,
        RESIZEABLE,
        SINGLE_MESSAGE;

    }
}

