/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization.protobuf;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.serialization.ByteBufferConsumer;
import datadog.trace.core.serialization.Codec;
import datadog.trace.core.serialization.EncodingCache;
import datadog.trace.core.serialization.Writable;
import datadog.trace.core.serialization.WritableFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Map;

public class ProtobufWriter
extends WritableFormatter {
    private static final int VARINT = 0;
    private static final int FIXED_64 = 1;
    private static final int LENGTH_DELIMITED = 2;
    private static final int FIXED_32 = 5;
    private final Deque<Context> pool = new ArrayDeque<Context>();
    private final Deque<Context> stack = new ArrayDeque<Context>();
    private final Context root;
    private Context active;

    public ProtobufWriter(Codec codec, ByteBufferConsumer sink, ByteBuffer buffer, boolean manualReset) {
        super(codec, sink, buffer, manualReset ? EnumSet.of(WritableFormatter.Feature.MANUAL_RESET) : EnumSet.noneOf(WritableFormatter.Feature.class), 0);
        this.active = this.root = new Context(buffer);
        this.stack.push(this.active);
        this.pool.push(new Context());
        this.pool.push(new Context());
        this.pool.push(new Context());
    }

    public ProtobufWriter(Codec codec, ByteBufferConsumer sink, ByteBuffer buffer) {
        this(codec, sink, buffer, false);
    }

    public ProtobufWriter(ByteBufferConsumer sink, ByteBuffer buffer) {
        this(Codec.INSTANCE, sink, buffer);
    }

    public ProtobufWriter(ByteBufferConsumer sink, ByteBuffer buffer, boolean manualReset) {
        this(Codec.INSTANCE, sink, buffer, manualReset);
    }

    @Override
    public void reset() {
        this.initBuffer();
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(0);
        this.messageCount = 0;
        this.resetStack();
    }

    private void resetStack() {
        if (this.active != this.root) {
            this.recycle(this.active);
        }
        for (Context context : this.stack) {
            if (context == this.root) continue;
            this.recycle(context);
        }
        this.active = this.root;
    }

    private void recycle(Context context) {
        context.reset();
        this.pool.addLast(context);
    }

    private void enterContext(int elementCount, boolean array) {
        Context context = this.pool.isEmpty() ? new Context() : this.pool.removeFirst();
        context.elementCount = elementCount;
        context.inArray = array;
        this.stack.addFirst(context);
        this.active = context;
    }

    private void leaveContext() {
        if (this.active != this.root) {
            Context context = this.stack.removeFirst();
            this.active = this.stack.peek();
            assert (this.active != null);
            context.transferTo(this.active);
            this.recycle(context);
        }
    }

    @Override
    protected void writeHeader(boolean writeArray) {
        this.buffer.position(0);
    }

    @Override
    public void startMap(int elementCount) {
        this.enterContext(elementCount * 2, false);
    }

    @Override
    public void startStruct(int elementCount) {
        this.enterContext(elementCount, false);
    }

    @Override
    public void startArray(int elementCount) {
        this.enterContext(elementCount, true);
    }

    @Override
    public void writeNull() {
        this.active.writeNull();
    }

    @Override
    public void writeBoolean(boolean value) {
        this.active.writeBoolean(value);
    }

    @Override
    public void writeString(CharSequence s, EncodingCache encodingCache) {
        this.active.writeString(s, encodingCache);
    }

    @Override
    public void writeUTF8(byte[] string, int offset, int length) {
        this.active.writeUTF8(string, offset, length);
    }

    @Override
    public void writeUTF8(byte[] string) {
        this.active.writeUTF8(string);
    }

    @Override
    public void writeUTF8(UTF8BytesString string) {
        this.active.writeUTF8(string);
    }

    @Override
    public void writeBinary(byte[] binary) {
        this.active.writeBinary(binary);
    }

    @Override
    public void writeBinary(byte[] binary, int offset, int length) {
        this.active.writeBinary(binary, offset, length);
    }

    @Override
    public void writeBinary(ByteBuffer buffer) {
        this.active.writeBinary(buffer);
    }

    @Override
    public void writeInt(int value) {
        this.active.writeInt(value);
    }

    @Override
    public void writeSignedInt(int value) {
        this.active.writeSignedInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.active.writeLong(value);
    }

    @Override
    public void writeSignedLong(long value) {
        this.active.writeSignedLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.active.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.active.writeDouble(value);
    }

    private class Context
    implements Writable {
        private final ByteBuffer buffer;
        private int elementCount = Integer.MAX_VALUE;
        private int fieldNumber = 1;
        private int position = 0;
        private boolean inArray = false;

        private Context(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        private Context() {
            this(ByteBuffer.allocate(524288));
        }

        void reset() {
            this.buffer.position(0);
            this.buffer.limit(this.buffer.capacity());
            this.fieldNumber = 1;
            this.position = 0;
            this.elementCount = Integer.MAX_VALUE;
        }

        void transferTo(Context target) {
            this.buffer.flip();
            target.writeBinary(this.buffer);
        }

        @Override
        public void writeNull() {
            this.nextElement();
        }

        @Override
        public void writeBoolean(boolean value) {
            if (value) {
                if (!this.inArray) {
                    this.writeTag(0);
                }
                this.writeVarInt(1);
            }
            this.nextElement();
        }

        @Override
        public void writeObject(Object value, EncodingCache encodingCache) {
            ProtobufWriter.this.writeObject(value, encodingCache);
            this.nextElement();
        }

        @Override
        public void writeMap(Map<? extends CharSequence, ?> map, EncodingCache encodingCache) {
            if (!map.isEmpty()) {
                ProtobufWriter.this.writeMap((Map<? extends CharSequence, ? extends Object>)map, encodingCache);
            }
            this.nextElement();
        }

        @Override
        public void writeString(CharSequence s, EncodingCache encodingCache) {
            if (s instanceof UTF8BytesString) {
                this.writeUTF8((UTF8BytesString)s);
            } else {
                this.writeUTF8(String.valueOf(s).getBytes(StandardCharsets.UTF_8));
            }
        }

        @Override
        public void writeUTF8(byte[] string, int offset, int length) {
            if (length != 0) {
                this.writeLengthPrefix(length);
                this.buffer.put(string, offset, length);
            }
            this.nextElement();
        }

        @Override
        public void writeUTF8(byte[] string) {
            if (string.length != 0) {
                this.writeLengthPrefix(string.length);
                this.buffer.put(string);
            }
            this.nextElement();
        }

        @Override
        public void writeUTF8(UTF8BytesString string) {
            if (string.encodedLength() != 0) {
                this.writeLengthPrefix(string.encodedLength());
                string.transferTo(this.buffer);
            }
            this.nextElement();
        }

        @Override
        public void writeBinary(byte[] binary) {
            this.writeBinary(binary, 0, binary.length);
        }

        @Override
        public void writeBinary(byte[] binary, int offset, int length) {
            if (length != 0) {
                this.writeLengthPrefix(length);
                this.buffer.put(binary, offset, length);
            }
            this.nextElement();
        }

        @Override
        public void writeBinary(ByteBuffer buffer) {
            if (buffer.hasRemaining()) {
                this.writeLengthPrefix(buffer.remaining());
                this.buffer.put(buffer);
            }
            this.nextElement();
        }

        @Override
        public void startMap(int elementCount) {
            if (elementCount != 0) {
                ProtobufWriter.this.startMap(elementCount);
            }
        }

        @Override
        public void startStruct(int elementCount) {
            if (elementCount != 0) {
                ProtobufWriter.this.startStruct(elementCount);
            }
        }

        @Override
        public void startArray(int elementCount) {
            if (elementCount != 0) {
                ProtobufWriter.this.startArray(elementCount);
            }
        }

        @Override
        public void writeInt(int value) {
            if (value != 0) {
                if (!this.inArray) {
                    this.writeTag(0);
                }
                this.writeVarInt(value);
            }
            this.nextElement();
        }

        @Override
        public void writeSignedInt(int value) {
            this.writeInt(value << 1 ^ value >> 31);
        }

        @Override
        public void writeLong(long value) {
            if (value != 0L) {
                if (!this.inArray) {
                    this.writeTag(0);
                }
                this.writeVarInt(value);
            }
            this.nextElement();
        }

        @Override
        public void writeSignedLong(long value) {
            this.writeLong(value << 1 ^ value >> 63);
        }

        @Override
        public void writeFloat(float value) {
            if (value != 0.0f) {
                if (!this.inArray) {
                    this.writeTag(5);
                }
                this.buffer.putFloat(value);
            }
            this.nextElement();
        }

        @Override
        public void writeDouble(double value) {
            if (value != 0.0) {
                if (!this.inArray) {
                    this.writeTag(1);
                }
                this.buffer.putDouble(value);
            }
            this.nextElement();
        }

        private void writeLengthPrefix(int length) {
            this.writeTag(2);
            this.writeVarInt(length);
        }

        private void nextElement() {
            if (!this.inArray) {
                ++this.fieldNumber;
            }
            ++this.position;
            this.checkElementCountInvariant();
        }

        private void checkElementCountInvariant() {
            if (this.position == this.elementCount) {
                ProtobufWriter.this.leaveContext();
            }
        }

        void writeTag(int wireType) {
            this.writeVarInt(this.fieldNumber << 3 | wireType);
        }

        private void writeVarInt(int value) {
            int length = this.varIntLength(value);
            for (int i = 0; i < length; ++i) {
                this.buffer.put((byte)(value & 0x7F | 0x80));
                value >>>= 7;
            }
            this.buffer.put((byte)value);
        }

        private void writeVarInt(long value) {
            int length = this.varIntLength(value);
            for (int i = 0; i < length; ++i) {
                this.buffer.put((byte)(value & 0x7FL | 0x80L));
                value >>>= 7;
            }
            this.buffer.put((byte)value);
        }

        private int varIntLength(int value) {
            return (31 - Integer.numberOfLeadingZeros(value)) / 7;
        }

        private int varIntLength(long value) {
            return (63 - Long.numberOfLeadingZeros(value)) / 7;
        }
    }
}

