/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.taginterceptor;

import datadog.trace.api.Config;

public class RuleFlags {
    private final boolean[] flags;

    public RuleFlags() {
        this(Config.get());
    }

    public RuleFlags(Config config) {
        Feature[] features = Feature.values();
        this.flags = new boolean[features.length];
        for (Feature feature : features) {
            if (!config.isRuleEnabled(feature.name)) continue;
            this.flags[feature.ordinal()] = true;
        }
    }

    public boolean isEnabled(Feature feature) {
        return this.flags[feature.ordinal()];
    }

    public static enum Feature {
        RESOURCE_NAME("ResourceNameRule"),
        DB_STATEMENT("DBStatementRule"),
        FORCE_MANUAL_DROP("ForceManualDropTagInterceptor"),
        FORCE_MANUAL_KEEP("ForceManualKeepTagInterceptor"),
        PEER_SERVICE("PeerServiceTagInterceptor"),
        SERVICE_NAME("ServiceNameTagInterceptor"),
        SERVLET_CONTEXT("ServletContextTagInterceptor");

        private final String name;

        private Feature(String name) {
            this.name = name;
        }
    }
}

