/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.taginterceptor;

import datadog.trace.api.Config;
import datadog.trace.api.env.CapturedEnvironment;
import datadog.trace.core.ExclusiveSpan;
import datadog.trace.core.taginterceptor.RuleFlags;
import java.util.Set;

public class TagInterceptor {
    private final RuleFlags ruleFlags;
    private final boolean isServiceNameSetByUser;
    private final String inferredServiceName;
    private final Set<String> splitServiceTags;

    public TagInterceptor(RuleFlags ruleFlags) {
        this(Config.get().isServiceNameSetByUser(), CapturedEnvironment.get().getProperties().get("service.name"), Config.get().getSplitByTags(), ruleFlags);
    }

    public TagInterceptor(boolean isServiceNameSetByUser, String inferredServiceName, Set<String> splitServiceTags, RuleFlags ruleFlags) {
        this.isServiceNameSetByUser = isServiceNameSetByUser;
        this.inferredServiceName = inferredServiceName;
        this.splitServiceTags = splitServiceTags;
        this.ruleFlags = ruleFlags;
    }

    public boolean interceptTag(ExclusiveSpan span, String tag, Object value) {
        switch (tag) {
            case "resource.name": {
                return this.interceptResourceName(span, value);
            }
            case "db.statement": {
                return this.interceptDbStatement(span, value);
            }
            case "service.name": 
            case "service": {
                return this.interceptServiceName(RuleFlags.Feature.SERVICE_NAME, span, value);
            }
            case "peer.service": {
                return this.interceptServiceName(RuleFlags.Feature.PEER_SERVICE, span, value);
            }
            case "manual.keep": {
                return this.interceptSamplingPriority(RuleFlags.Feature.FORCE_MANUAL_KEEP, 2, span, value);
            }
            case "manual.drop": {
                return this.interceptSamplingPriority(RuleFlags.Feature.FORCE_MANUAL_DROP, -1, span, value);
            }
            case "servlet.context": {
                return this.interceptServletContext(span, value);
            }
            case "span.type": {
                return this.interceptSpanType(span, value);
            }
            case "_dd1.sr.eausr": {
                return this.interceptAnalyticsSampleRate(span, value);
            }
            case "error": {
                return this.interceptError(span, value);
            }
        }
        return this.intercept(span, tag, value);
    }

    private boolean intercept(ExclusiveSpan span, String tag, Object value) {
        if (this.splitServiceTags.contains(tag)) {
            span.setServiceName(String.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean interceptResourceName(ExclusiveSpan span, Object value) {
        if (this.ruleFlags.isEnabled(RuleFlags.Feature.RESOURCE_NAME)) {
            if (value instanceof CharSequence) {
                span.setResourceName((CharSequence)value);
            } else {
                span.setResourceName(String.valueOf(value));
            }
            return true;
        }
        return false;
    }

    private boolean interceptDbStatement(ExclusiveSpan span, Object value) {
        CharSequence resourceName;
        if (value instanceof CharSequence && (resourceName = (CharSequence)value).length() > 0) {
            span.setResourceName(resourceName);
        }
        return true;
    }

    private boolean interceptError(ExclusiveSpan span, Object value) {
        span.setError(TagInterceptor.asBoolean(value));
        return true;
    }

    private boolean interceptAnalyticsSampleRate(ExclusiveSpan span, Object value) {
        Number analyticsSampleRate = TagInterceptor.getOrTryParse(value);
        if (null != analyticsSampleRate) {
            span.setMetric("_dd1.sr.eausr", analyticsSampleRate);
        }
        return true;
    }

    private boolean interceptSpanType(ExclusiveSpan span, Object value) {
        if (value instanceof CharSequence) {
            span.setSpanType((CharSequence)value);
        } else {
            span.setType(String.valueOf(value));
        }
        return true;
    }

    private boolean interceptServiceName(RuleFlags.Feature feature, ExclusiveSpan span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            span.setServiceName(String.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean interceptSamplingPriority(RuleFlags.Feature feature, int priority, ExclusiveSpan span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            if (TagInterceptor.asBoolean(value)) {
                span.setSamplingPriority(priority);
            }
            return true;
        }
        return false;
    }

    private boolean interceptServletContext(ExclusiveSpan span, Object value) {
        if (this.isServiceNameSetByUser || !this.ruleFlags.isEnabled(RuleFlags.Feature.SERVLET_CONTEXT) || !span.getServiceName().isEmpty() && !span.getServiceName().equals(this.inferredServiceName) && !span.getServiceName().equals("unnamed-java-app")) {
            return false;
        }
        String contextName = String.valueOf(value).trim();
        if (!contextName.isEmpty()) {
            if (contextName.charAt(0) == '/') {
                if (contextName.length() > 1) {
                    span.setServiceName(contextName.substring(1));
                }
            } else {
                span.setServiceName(contextName);
            }
        }
        return false;
    }

    private static boolean asBoolean(Object value) {
        return Boolean.TRUE.equals(value) || !Boolean.FALSE.equals(value) && Boolean.parseBoolean(String.valueOf(value));
    }

    private static Number getOrTryParse(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

