/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTracer;
import datadog.opentracing.scopemanager.ContinuableScope;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
extends ConcurrentLinkedDeque<DDSpan> {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private final DDTracer tracer;
    private final long traceId;
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Set<WeakReference<?>> weakReferences = Sets.newConcurrentHashSet();
    private final AtomicInteger pendingReferenceCount = new AtomicInteger(0);
    private final AtomicBoolean isWritten = new AtomicBoolean(false);

    PendingTrace(DDTracer tracer, long traceId) {
        this.tracer = tracer;
        this.traceId = traceId;
        SpanCleaner.pendingTraces.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpan(DDSpan span) {
        if (span.context().getTraceId() != this.traceId) {
            log.debug("{} - span registered for wrong trace ({})", (Object)span, (Object)this.traceId);
            return;
        }
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                span.ref = new WeakReference<DDSpan>(span, this.referenceQueue);
                this.weakReferences.add(span.ref);
                int count = this.pendingReferenceCount.incrementAndGet();
                log.debug("traceId: {} -- registered span {}. count = {}", new Object[]{this.traceId, span, count});
            } else {
                log.debug("span {} already registered in trace {}", (Object)span, (Object)this.traceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSpan(DDSpan span) {
        if (span.context().getTraceId() != this.traceId) {
            log.debug("{} - span expired for wrong trace ({})", (Object)span, (Object)this.traceId);
            return;
        }
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                log.debug("span {} not registered in trace {}", (Object)span, (Object)this.traceId);
            } else {
                this.weakReferences.remove(span.ref);
                span.ref.clear();
                span.ref = null;
                this.expireReference();
            }
        }
    }

    public void addSpan(DDSpan span) {
        if (span.getDurationNano() == 0L) {
            log.debug("{} - added to trace, but not complete.", (Object)span);
            return;
        }
        if (this.traceId != span.getTraceId()) {
            log.debug("{} - added to a mismatched trace.", (Object)span);
            return;
        }
        if (!this.isWritten.get()) {
            this.addFirst(span);
        } else {
            log.debug("{} - finished after trace reported.", (Object)span);
        }
        this.expireSpan(span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref == null) {
                continuation.ref = new WeakReference<ContinuableScope.Continuation>(continuation, this.referenceQueue);
                this.weakReferences.add(continuation.ref);
                int count = this.pendingReferenceCount.incrementAndGet();
                log.debug("traceId: {} -- registered continuation {}. count = {}", new Object[]{this.traceId, continuation, count});
            } else {
                log.debug("continuation {} already registered in trace {}", (Object)continuation, (Object)this.traceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref == null) {
                log.debug("continuation {} not registered in trace {}", (Object)continuation, (Object)this.traceId);
            } else {
                this.weakReferences.remove(continuation.ref);
                continuation.ref.clear();
                continuation.ref = null;
                this.expireReference();
            }
        }
    }

    private void expireReference() {
        int count = this.pendingReferenceCount.decrementAndGet();
        if (count == 0) {
            this.write();
        }
        log.debug("traceId: {} -- Expired reference. count = {}", (Object)this.traceId, (Object)count);
    }

    private void write() {
        if (this.isWritten.compareAndSet(false, true)) {
            SpanCleaner.pendingTraces.remove(this);
            if (!this.isEmpty()) {
                log.debug("Writing {} spans to {}.", (Object)this.size(), (Object)this.tracer.writer);
                this.tracer.write(this);
            }
        }
    }

    public synchronized boolean clean() {
        Reference ref;
        int count = 0;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.weakReferences.remove(ref);
            ++count;
            this.expireReference();
        }
        if (count > 0) {
            log.debug("{} unfinished spans garbage collected!", (Object)count);
        }
        return count > 0;
    }

    public static void awaitGC() {
        System.gc();
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (ref.get() != null) {
            System.gc();
        }
    }

    static {
        SpanCleaner.start();
    }

    private static class SpanCleaner
    implements Runnable {
        private static final long CLEAN_FREQUENCY = 1L;
        private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("dd-span-cleaner-%d").setDaemon(true).build();
        private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, FACTORY);
        static final Set<PendingTrace> pendingTraces = Sets.newConcurrentHashSet();

        private SpanCleaner() {
        }

        static void start() {
            EXECUTOR_SERVICE.scheduleAtFixedRate(new SpanCleaner(), 0L, 1L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            for (PendingTrace trace : pendingTraces) {
                trace.clean();
            }
        }
    }
}

