/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.DDSpan;
import datadog.opentracing.DDSpanContext;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.trace.context.TraceScope;
import io.opentracing.Scope;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScope
implements Scope,
TraceScope {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScope.class);
    private final ContextualScopeManager scopeManager;
    private final DDSpan spanUnderScope;
    private final boolean finishOnClose;
    private final AtomicInteger openCount;
    private final Scope toRestore;
    private final Continuation continuation;
    private final AtomicBoolean isAsyncPropagating = new AtomicBoolean(false);

    ContinuableScope(ContextualScopeManager scopeManager, DDSpan spanUnderScope, boolean finishOnClose) {
        this(scopeManager, new AtomicInteger(1), null, spanUnderScope, finishOnClose);
    }

    private ContinuableScope(ContextualScopeManager scopeManager, AtomicInteger openCount, Continuation continuation, DDSpan spanUnderScope, boolean finishOnClose) {
        this.scopeManager = scopeManager;
        this.openCount = openCount;
        this.continuation = continuation;
        this.spanUnderScope = spanUnderScope;
        this.finishOnClose = finishOnClose;
        this.toRestore = scopeManager.tlsScope.get();
        scopeManager.tlsScope.set(this);
    }

    public void close() {
        if (null != this.continuation) {
            this.spanUnderScope.context().getTrace().cancelContinuation(this.continuation);
        }
        if (this.openCount.decrementAndGet() == 0 && this.finishOnClose) {
            this.spanUnderScope.finish();
        }
        if (this.scopeManager.tlsScope.get() == this) {
            this.scopeManager.tlsScope.set(this.toRestore);
        }
    }

    public DDSpan span() {
        return this.spanUnderScope;
    }

    public boolean isAsyncPropagating() {
        return this.isAsyncPropagating.get();
    }

    public void setAsyncPropagation(boolean value) {
        this.isAsyncPropagating.set(value);
    }

    public Continuation capture() {
        if (this.isAsyncPropagating()) {
            return new Continuation();
        }
        return null;
    }

    public class Continuation
    implements Closeable,
    TraceScope.Continuation {
        public WeakReference<Continuation> ref;
        private final AtomicBoolean used = new AtomicBoolean(false);
        private final PendingTrace trace;

        private Continuation() {
            ContinuableScope.this.openCount.incrementAndGet();
            DDSpanContext context = ContinuableScope.this.spanUnderScope.context();
            this.trace = context.getTrace();
            this.trace.registerContinuation(this);
        }

        public ContinuableScope activate() {
            if (this.used.compareAndSet(false, true)) {
                return new ContinuableScope(ContinuableScope.this.scopeManager, ContinuableScope.this.openCount, this, ContinuableScope.this.spanUnderScope, ContinuableScope.this.finishOnClose);
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed.  Returning a new scope. Spans will not be linked.");
            return new ContinuableScope(ContinuableScope.this.scopeManager, new AtomicInteger(1), null, ContinuableScope.this.spanUnderScope, ContinuableScope.this.finishOnClose);
        }

        @Override
        public void close() {
            if (this.used.compareAndSet(false, true)) {
                this.trace.cancelContinuation(this);
                ContinuableScope.this.close();
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }
    }
}

